/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.util.EntityUtils;
import org.apache.marmotta.client.ClientConfiguration;
import org.apache.marmotta.client.exception.MarmottaClientException;
import org.apache.marmotta.client.util.HTTPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportClient {
    private static Logger log = LoggerFactory.getLogger(ImportClient.class);
    private static final String URL_TYPES_SERVICE = "/import/types";
    private static final String URL_UPLOAD_SERVICE = "/import/upload";
    private ClientConfiguration config;
    private Set<String> acceptableTypes = new HashSet<String>();

    public ImportClient(ClientConfiguration config) {
        this.config = config;
        try {
            this.acceptableTypes = this.getSupportedTypes();
        }
        catch (IOException e) {
            log.error("I/O Exception while trying to retrieve supported types", (Throwable)e);
        }
        catch (MarmottaClientException e) {
            log.error("Client Exception while trying to retrieve supported types", (Throwable)e);
        }
    }

    public Set<String> getSupportedTypes() throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_TYPES_SERVICE;
        HttpGet get = new HttpGet(serviceUrl);
        get.setHeader("Accept", "application/json");
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    Set result;
                    log.debug("list of import types retrieved successfully");
                    ObjectMapper mapper = new ObjectMapper();
                    Set set = result = (Set)mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Set<String>>(){});
                    return set;
                }
            }
            log.error("error retrieving list of import types: {} {}", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
            throw new MarmottaClientException("error retrieving list of import types: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        finally {
            get.releaseConnection();
        }
    }

    public void uploadDataset(InputStream in, String mimeType, String context) throws IOException, MarmottaClientException, URISyntaxException {
        HttpClient httpClient = HTTPUtil.createClient(this.config, context);
        this.uploadDataset(in, mimeType, httpClient);
    }

    public void uploadDataset(InputStream in, String mimeType) throws IOException, MarmottaClientException, URISyntaxException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        this.uploadDataset(in, mimeType, httpClient);
    }

    private void uploadDataset(final InputStream in, final String mimeType, HttpClient httpClient) throws IOException, URISyntaxException {
        HttpPost post = HTTPUtil.createPost(URL_UPLOAD_SERVICE, this.config);
        post.setHeader("Content-Type", mimeType);
        ContentProducer cp = new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                ByteStreams.copy((InputStream)in, (OutputStream)outstream);
            }
        };
        post.setEntity((HttpEntity)new EntityTemplate(cp));
        ResponseHandler<Boolean> handler = new ResponseHandler<Boolean>(){

            public Boolean handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                EntityUtils.consume((HttpEntity)response.getEntity());
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: {
                        log.debug("dataset uploaded updated successfully");
                        return true;
                    }
                    case 412: {
                        log.error("mime type {} not acceptable by import service", (Object)mimeType);
                        return false;
                    }
                }
                log.error("error uploading dataset: {} {}", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                return false;
            }
        };
        try {
            httpClient.execute((HttpUriRequest)post, (ResponseHandler)handler);
        }
        catch (IOException ex) {
            post.abort();
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
    }

    public void uploadDataset(String data, String mimeType) throws IOException, MarmottaClientException, URISyntaxException {
        this.uploadDataset(new ByteArrayInputStream(data.getBytes("utf-8")), mimeType);
    }

    public void uploadDataset(String data, String mimeType, String context) throws IOException, MarmottaClientException, URISyntaxException {
        this.uploadDataset((InputStream)new ByteArrayInputStream(data.getBytes("utf-8")), mimeType, context);
    }
}

