/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.clients;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.marmotta.client.ClientConfiguration;
import org.apache.marmotta.client.exception.ContentFormatException;
import org.apache.marmotta.client.exception.MarmottaClientException;
import org.apache.marmotta.client.exception.NotFoundException;
import org.apache.marmotta.client.model.rdf.RDFNode;
import org.apache.marmotta.client.util.HTTPUtil;
import org.apache.marmotta.client.util.RDFJSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDPathClient {
    private static Logger log = LoggerFactory.getLogger(LDPathClient.class);
    private static final String URL_PATH_SERVICE = "/ldpath/path";
    private static final String URL_PROGRAM_SERVICE = "/ldpath/program";
    private ClientConfiguration config;

    public LDPathClient(ClientConfiguration config) {
        this.config = config;
    }

    public List<RDFNode> evaluatePath(String uri, String path) throws MarmottaClientException, IOException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_PATH_SERVICE + "?path=" + URLEncoder.encode(path, "utf-8") + "&uri=" + URLEncoder.encode(uri, "utf-8");
        HttpGet get = new HttpGet(serviceUrl);
        get.setHeader("Accept", "application/json");
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("LDPath Path Query {} evaluated successfully", (Object)path);
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
                    List serverResult = (List)mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
                    ArrayList<RDFNode> result = new ArrayList<RDFNode>();
                    for (Map value : serverResult) {
                        result.add(RDFJSONParser.parseRDFJSONNode(value));
                    }
                    ArrayList<RDFNode> arrayList = result;
                    return arrayList;
                }
                case 400: {
                    log.error("the server did not accept the uri ({}) or path ({}) arguments", (Object)uri, (Object)path);
                    throw new ContentFormatException("the server did not accept the uri (" + uri + ") or path (" + path + ") arguments");
                }
                case 404: {
                    log.error("the resource with URI {} does not exist on the server", (Object)uri);
                    throw new NotFoundException("the resource with URI " + uri + " does not exist on the server");
                }
            }
            log.error("error evaluating LDPath Path Query {}: {} {}", new Object[]{path, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
            throw new MarmottaClientException("error evaluating LDPath Path Query " + path + ": " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        finally {
            get.releaseConnection();
        }
    }

    public Map<String, List<RDFNode>> evaluateProgram(String uri, String program) throws MarmottaClientException, IOException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_PROGRAM_SERVICE + "?program=" + URLEncoder.encode(program, "utf-8") + "&uri=" + URLEncoder.encode(uri, "utf-8");
        HttpGet get = new HttpGet(serviceUrl);
        get.setHeader("Accept", "application/json");
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("LDPath Program Query evaluated successfully:\n{}", (Object)program);
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
                    Map serverResult = (Map)mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, List<Map<String, String>>>>(){});
                    HashMap result = new HashMap();
                    for (Map.Entry field : serverResult.entrySet()) {
                        ArrayList<RDFNode> row = new ArrayList<RDFNode>();
                        for (Map node : (List)field.getValue()) {
                            row.add(RDFJSONParser.parseRDFJSONNode(node));
                        }
                        result.put(field.getKey(), row);
                    }
                    HashMap hashMap = result;
                    return hashMap;
                }
                case 400: {
                    log.error("the server did not accept the uri ({}) or program ({}) arguments", (Object)uri, (Object)program);
                    throw new ContentFormatException("the server did not accept the uri (" + uri + ") or program (" + program + ") arguments");
                }
                case 404: {
                    log.error("the resource with URI {} does not exist on the server", (Object)uri);
                    throw new NotFoundException("the resource with URI " + uri + " does not exist on the server");
                }
            }
            log.error("error evaluating LDPath Program Query: {} {}", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
            throw new MarmottaClientException("error evaluating LDPath Program Query: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        finally {
            get.releaseConnection();
        }
    }
}

