/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.clients;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.util.EntityUtils;
import org.apache.marmotta.client.ClientConfiguration;
import org.apache.marmotta.client.exception.ContentFormatException;
import org.apache.marmotta.client.exception.MarmottaClientException;
import org.apache.marmotta.client.exception.NotFoundException;
import org.apache.marmotta.client.model.content.Content;
import org.apache.marmotta.client.model.meta.Metadata;
import org.apache.marmotta.client.util.HTTPUtil;
import org.apache.marmotta.client.util.RDFJSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClient {
    private static Logger log = LoggerFactory.getLogger(ResourceClient.class);
    private static final String URL_RESOURCE_SERVICE = "/resource";
    private ClientConfiguration config;

    public ResourceClient(ClientConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createResource(String uri) throws IOException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        HttpPost post = new HttpPost(this.getServiceUrl(uri));
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("resource {} already existed, not creating new", (Object)uri);
                    boolean bl = true;
                    return bl;
                }
                case 201: {
                    log.debug("resource {} created", (Object)uri);
                    boolean bl = true;
                    return bl;
                }
            }
            log.error("error creating resource {}: {} {}", new Object[]{uri, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
            boolean bl = true;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            log.error("could not encode URI parameter", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsResource(String uri) throws IOException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        HttpOptions options = new HttpOptions(this.getServiceUrl(uri));
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)options);
            if (response.containsHeader("Access-Control-Allow-Methods") && response.getFirstHeader("Access-Control-Allow-Methods").getValue().equals("POST")) {
                boolean bl = false;
                return bl;
            }
            if (response.containsHeader("Access-Control-Allow-Methods") && response.getFirstHeader("Access-Control-Allow-Methods").getValue().contains("GET")) {
                boolean bl = true;
                return bl;
            }
            log.warn("OPTIONS response did not contain a access-control-allow-methods header");
            boolean bl = false;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            log.error("could not encode URI parameter", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            options.releaseConnection();
        }
    }

    /*
     * Exception decompiling
     */
    public Metadata getResourceMetadata(String uri) throws IOException, MarmottaClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateResourceMetadata(final String uri, final Metadata metadata) throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        HttpPut put = new HttpPut(this.getServiceUrl(uri));
        put.setHeader("Content-Type", "application/rdf+json; rel=meta");
        ContentProducer cp = new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                RDFJSONParser.serializeRDFJSON((Map<String, Metadata>)ImmutableMap.of((Object)uri, (Object)metadata), outstream);
            }
        };
        put.setEntity((HttpEntity)new EntityTemplate(cp));
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)put);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("metadata for resource {} updated", (Object)uri);
                    return;
                }
                case 415: {
                    log.error("server does not support metadata type application/json for resource {}, cannot update", (Object)uri);
                    throw new ContentFormatException("server does not support metadata type application/json for resource " + uri);
                }
                case 404: {
                    log.error("resource {} does not exist, cannot update", (Object)uri);
                    throw new NotFoundException("resource " + uri + " does not exist, cannot update");
                }
                default: {
                    log.error("error updating resource {}: {} {}", new Object[]{uri, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                    throw new MarmottaClientException("error updating resource " + uri + ": " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("could not encode URI parameter", (Throwable)e);
            throw new MarmottaClientException("could not encode URI parameter");
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * Exception decompiling
     */
    public Content getResourceContent(String uri, String mimeType) throws IOException, MarmottaClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateResourceContent(final String uri, final Content content) throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        HttpPut put = new HttpPut(this.getServiceUrl(uri));
        put.setHeader("Content-Type", content.getMimeType() + "; rel=content");
        ContentProducer cp = new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                ByteStreams.copy((InputStream)content.getStream(), (OutputStream)outstream);
            }
        };
        put.setEntity((HttpEntity)new EntityTemplate(cp));
        ResponseHandler<Boolean> handler = new ResponseHandler<Boolean>(){

            public Boolean handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                EntityUtils.consume((HttpEntity)response.getEntity());
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: {
                        log.debug("content for resource {} updated", (Object)uri);
                        return true;
                    }
                    case 406: {
                        log.error("server does not support content type {} for resource {}, cannot update", (Object)content.getMimeType(), (Object)uri);
                        return false;
                    }
                    case 404: {
                        log.error("resource {} does not exist, cannot update", (Object)uri);
                        return false;
                    }
                }
                log.error("error updating resource {}: {} {}", new Object[]{uri, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                return false;
            }
        };
        try {
            httpClient.execute((HttpUriRequest)put, (ResponseHandler)handler);
        }
        catch (IOException ex) {
            put.abort();
            throw ex;
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteResource(String uri) throws IOException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        HttpDelete delete = new HttpDelete(this.getServiceUrl(uri));
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)delete);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("resource {} deleted", (Object)uri);
                    return;
                }
                case 400: {
                    log.error("resource {} invalid, cannot delete", (Object)uri);
                    return;
                }
                case 404: {
                    log.error("resource {} does not exist, cannot delete", (Object)uri);
                    return;
                }
                default: {
                    log.error("error deleting resource {}: {} {}", new Object[]{uri, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                    return;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("could not encode URI parameter", (Throwable)e);
            return;
        }
        finally {
            delete.releaseConnection();
        }
    }

    private String getServiceUrl(String uri) throws UnsupportedEncodingException {
        return this.config.getMarmottaUri() + URL_RESOURCE_SERVICE + "?uri=" + URLEncoder.encode(uri, "utf-8");
    }
}

