/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.clients;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.marmotta.client.ClientConfiguration;
import org.apache.marmotta.client.exception.MarmottaClientException;
import org.apache.marmotta.client.model.rdf.RDFNode;
import org.apache.marmotta.client.model.rdf.URI;
import org.apache.marmotta.client.model.sparql.SPARQLResult;
import org.apache.marmotta.client.util.HTTPUtil;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.UnsupportedQueryResultFormatException;
import org.openrdf.query.resultio.helpers.QueryResultCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLClient {
    private static Logger log = LoggerFactory.getLogger(SPARQLClient.class);
    private static final String URL_QUERY_SERVICE = "/sparql/select";
    private static final String URL_UPDATE_SERVICE = "/sparql/update";
    private ClientConfiguration config;

    public SPARQLClient(ClientConfiguration config) {
        this.config = config;
    }

    public SPARQLResult select(String query) throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_QUERY_SERVICE + "?query=" + URLEncoder.encode(query, "utf-8");
        HttpGet get = new HttpGet(serviceUrl);
        get.setHeader("Accept", TupleQueryResultFormat.JSON.getDefaultMIMEType());
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("SPARQL Query {} evaluated successfully", (Object)query);
                    QueryResultCollector results = new QueryResultCollector();
                    SPARQLClient.parse(response.getEntity().getContent(), TupleQueryResultFormat.JSON, (QueryResultHandler)results, (ValueFactory)ValueFactoryImpl.getInstance());
                    if (!results.getHandledTuple() || results.getBindingSets().isEmpty()) {
                        SPARQLResult sPARQLResult = null;
                        return sPARQLResult;
                    }
                    List fieldNames = results.getBindingNames();
                    SPARQLResult result = new SPARQLResult((Set<String>)new LinkedHashSet<String>(fieldNames));
                    for (BindingSet nextRow : results.getBindingSets()) {
                        HashMap<String, URI> row = new HashMap<String, URI>();
                        for (String nextBindingName : fieldNames) {
                            if (!nextRow.hasBinding(nextBindingName)) continue;
                            Binding nextBinding = nextRow.getBinding(nextBindingName);
                            Value nodeDef = nextBinding.getValue();
                            RDFNode node = null;
                            if (nodeDef instanceof org.openrdf.model.URI) {
                                node = new URI(nodeDef.stringValue());
                            } else if (nodeDef instanceof BNode) {
                                node = new org.apache.marmotta.client.model.rdf.BNode(((BNode)nodeDef).getID());
                            } else if (nodeDef instanceof Literal) {
                                Literal nodeLiteral = (Literal)nodeDef;
                                node = nodeLiteral.getLanguage() != null ? new org.apache.marmotta.client.model.rdf.Literal(nodeLiteral.getLabel(), nodeLiteral.getLanguage()) : (nodeLiteral.getDatatype() != null ? new org.apache.marmotta.client.model.rdf.Literal(nodeLiteral.getLabel(), new URI(nodeLiteral.getDatatype().stringValue())) : new org.apache.marmotta.client.model.rdf.Literal(nodeLiteral.getLabel()));
                            } else {
                                log.error("unknown result node type: {}", (Object)nodeDef);
                            }
                            if (node == null) continue;
                            row.put(nextBindingName, (URI)node);
                        }
                        result.add(row);
                    }
                    SPARQLResult sPARQLResult = result;
                    return sPARQLResult;
                }
            }
            try {
                log.error("error evaluating SPARQL Select Query {}: {} {}", new Object[]{query, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                throw new MarmottaClientException("error evaluating SPARQL Select Query " + query + ": " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
            }
            catch (TupleQueryResultHandlerException e) {
                throw new MarmottaClientException("error evaluating SPARQL Select Query ", e);
            }
            catch (QueryResultParseException e) {
                throw new MarmottaClientException("error evaluating SPARQL Select Query ", e);
            }
            catch (UnsupportedQueryResultFormatException e) {
                throw new MarmottaClientException("error evaluating SPARQL Select Query ", e);
            }
            catch (IllegalStateException e) {
                throw new MarmottaClientException("error evaluating SPARQL Select Query ", e);
            }
            catch (QueryResultHandlerException e) {
                throw new MarmottaClientException("error evaluating SPARQL Select Query ", e);
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    public boolean ask(String askQuery) throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_QUERY_SERVICE + "?query=" + URLEncoder.encode(askQuery, "utf-8");
        HttpGet get = new HttpGet(serviceUrl);
        get.setHeader("Accept", BooleanQueryResultFormat.JSON.getDefaultMIMEType());
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("SPARQL ASK Query {} evaluated successfully", (Object)askQuery);
                    QueryResultCollector results = new QueryResultCollector();
                    SPARQLClient.parse(response.getEntity().getContent(), BooleanQueryResultFormat.JSON, (QueryResultHandler)results, (ValueFactory)ValueFactoryImpl.getInstance());
                    if (!results.getHandledBoolean()) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = results.getBoolean();
                    return bl;
                }
            }
            try {
                log.error("error evaluating SPARQL ASK Query {}: {} {}", new Object[]{askQuery, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                throw new MarmottaClientException("error evaluating SPARQL ASK Query " + askQuery + ": " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
            }
            catch (TupleQueryResultHandlerException e) {
                throw new MarmottaClientException("error evaluating SPARQL Ask Query ", e);
            }
            catch (QueryResultParseException e) {
                throw new MarmottaClientException("error evaluating SPARQL Ask Query ", e);
            }
            catch (UnsupportedQueryResultFormatException e) {
                throw new MarmottaClientException("error evaluating SPARQL Ask Query ", e);
            }
            catch (IllegalStateException e) {
                throw new MarmottaClientException("error evaluating SPARQL Ask Query ", e);
            }
            catch (QueryResultHandlerException e) {
                throw new MarmottaClientException("error evaluating SPARQL Ask Query ", e);
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(String updateQuery) throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_UPDATE_SERVICE + "?update=" + URLEncoder.encode(updateQuery, "utf-8");
        HttpGet get = new HttpGet(serviceUrl);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("SPARQL UPDATE Query {} evaluated successfully", (Object)updateQuery);
                    return;
                }
                default: {
                    log.error("error evaluating SPARQL UPDATE Query {}: {} {}", new Object[]{updateQuery, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                    throw new MarmottaClientException("error evaluating SPARQL UPDATE Query " + updateQuery + ": " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
                }
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    private static void parse(InputStream in, TupleQueryResultFormat format, QueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, QueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)format);
        parser.setValueFactory(valueFactory);
        parser.setQueryResultHandler(handler);
        parser.parseQueryResult(in);
    }

    private static void parse(InputStream in, BooleanQueryResultFormat format, QueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, QueryResultHandlerException, UnsupportedQueryResultFormatException {
        BooleanQueryResultParser parser = QueryResultIO.createParser((BooleanQueryResultFormat)format);
        parser.setValueFactory(valueFactory);
        parser.setQueryResultHandler(handler);
        parser.parseQueryResult(in);
    }
}

