/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.model.rdf;

import org.apache.marmotta.client.model.rdf.RDFNode;
import org.apache.marmotta.client.model.rdf.URI;

public class Literal
extends RDFNode {
    private String content;
    private String language;
    private URI type;

    public Literal(String content) {
        this.content = content;
    }

    public Literal(String content, String language) {
        this.content = content;
        this.language = language;
    }

    public Literal(String content, URI type) {
        this.content = content;
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public int getInt() {
        return Integer.parseInt(this.content);
    }

    public long getLong() {
        return Long.parseLong(this.content);
    }

    public double getDouble() {
        return Double.parseDouble(this.content);
    }

    public float getFloat() {
        return Float.parseFloat(this.content);
    }

    public boolean getBoolean() {
        return Boolean.getBoolean(this.content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Literal literal = (Literal)o;
        if (!this.content.equals(literal.content)) {
            return false;
        }
        if (this.language != null ? !this.language.equals(literal.language) : literal.language != null) {
            return false;
        }
        return this.type != null ? this.type.equals(literal.type) : literal.type == null;
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.content;
    }
}

