/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.beats.handler;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.listen.dispatcher.AsyncChannelDispatcher;
import org.apache.nifi.processor.util.listen.event.Event;
import org.apache.nifi.processor.util.listen.event.EventFactory;
import org.apache.nifi.processor.util.listen.handler.socket.StandardSocketChannelHandler;
import org.apache.nifi.processor.util.listen.response.ChannelResponder;
import org.apache.nifi.processor.util.listen.response.socket.SocketChannelResponder;
import org.apache.nifi.processors.beats.frame.BeatsDecoder;
import org.apache.nifi.processors.beats.frame.BeatsFrame;
import org.apache.nifi.processors.beats.frame.BeatsFrameException;
import org.apache.nifi.processors.beats.handler.BeatsFrameHandler;

public class BeatsSocketChannelHandler<E extends Event<SocketChannel>>
extends StandardSocketChannelHandler<E> {
    private BeatsDecoder decoder;
    private BeatsFrameHandler<E> frameHandler;

    public BeatsSocketChannelHandler(SelectionKey key, AsyncChannelDispatcher dispatcher, Charset charset, EventFactory<E> eventFactory, BlockingQueue<E> events, ComponentLog logger) {
        super(key, dispatcher, charset, eventFactory, events, logger);
        this.decoder = new BeatsDecoder(charset, logger);
        this.frameHandler = new BeatsFrameHandler<E>(key, charset, eventFactory, events, dispatcher, logger);
    }

    protected void processBuffer(SocketChannel socketChannel, ByteBuffer socketBuffer) throws InterruptedException, IOException {
        int total = socketBuffer.remaining();
        InetAddress sender = socketChannel.socket().getInetAddress();
        try {
            for (int i = 0; i < total; ++i) {
                byte currByte = socketBuffer.get();
                if (!this.decoder.process(currByte)) continue;
                List<BeatsFrame> frames = this.decoder.getFrames();
                for (BeatsFrame frame : frames) {
                    this.logger.debug("Received Beats frame with transaction {} and command {}", new Object[]{frame.getSeqNumber(), frame.getSeqNumber()});
                    if (frame.getFrameType() == 87) continue;
                    SocketChannelResponder responder = new SocketChannelResponder(socketChannel);
                    this.frameHandler.handle(frame, (ChannelResponder<SocketChannel>)responder, sender.toString());
                }
                socketBuffer.mark();
            }
            this.logger.debug("Done processing buffer");
        }
        catch (BeatsFrameException rfe) {
            this.logger.error("Error reading Beats frames due to {}", new Object[]{rfe.getMessage()}, (Throwable)rfe);
            ((AsyncChannelDispatcher)this.dispatcher).completeConnection(this.key);
        }
    }

    public byte getDelimiter() {
        return 10;
    }
}

