/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.flume;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.SinkFactory;
import org.apache.flume.SourceFactory;
import org.apache.flume.sink.DefaultSinkFactory;
import org.apache.flume.source.DefaultSourceFactory;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processors.flume.ExecuteFlumeSink;
import org.apache.nifi.processors.flume.ExecuteFlumeSource;
import org.apache.nifi.processors.flume.util.FlowFileEvent;

public abstract class AbstractFlumeProcessor
extends AbstractSessionFactoryProcessor {
    protected static final SourceFactory SOURCE_FACTORY = new DefaultSourceFactory();
    protected static final SinkFactory SINK_FACTORY = new DefaultSinkFactory();

    protected static Event flowFileToEvent(FlowFile flowFile, ProcessSession session) {
        return new FlowFileEvent(flowFile, session);
    }

    protected static void transferEvent(final Event event, ProcessSession session, Relationship relationship) {
        FlowFile flowFile = session.create();
        flowFile = session.putAllAttributes(flowFile, event.getHeaders());
        flowFile = session.write(flowFile, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                out.write(event.getBody());
            }
        });
        session.getProvenanceReporter().create(flowFile);
        session.transfer(flowFile, relationship);
    }

    protected static Validator createSourceValidator() {
        return new Validator(){

            public ValidationResult validate(String subject, String value, ValidationContext context) {
                String reason = null;
                try {
                    ExecuteFlumeSource.SOURCE_FACTORY.create("NiFi Source", value);
                }
                catch (Exception ex) {
                    reason = ex.getLocalizedMessage();
                    reason = Character.toLowerCase(reason.charAt(0)) + reason.substring(1);
                }
                return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
            }
        };
    }

    protected static Validator createSinkValidator() {
        return new Validator(){

            public ValidationResult validate(String subject, String value, ValidationContext context) {
                String reason = null;
                try {
                    ExecuteFlumeSink.SINK_FACTORY.create("NiFi Sink", value);
                }
                catch (Exception ex) {
                    reason = ex.getLocalizedMessage();
                    reason = Character.toLowerCase(reason.charAt(0)) + reason.substring(1);
                }
                return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
            }
        };
    }

    protected static Context getFlumeContext(String flumeConfig, String prefix) {
        Properties flumeProperties = new Properties();
        if (flumeConfig != null) {
            try {
                flumeProperties.load(new StringReader(flumeConfig));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        HashMap parameters = Maps.newHashMap();
        for (String property : flumeProperties.stringPropertyNames()) {
            parameters.put(property, flumeProperties.getProperty(property));
        }
        return new Context((Map)new Context((Map)parameters).getSubProperties(prefix));
    }

    protected static Context getFlumeSourceContext(String flumeConfig, String agentName, String sourceName) {
        return AbstractFlumeProcessor.getFlumeContext(flumeConfig, agentName + ".sources." + sourceName + ".");
    }

    protected static Context getFlumeSinkContext(String flumeConfig, String agentName, String sinkName) {
        return AbstractFlumeProcessor.getFlumeContext(flumeConfig, agentName + ".sinks." + sinkName + ".");
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        ProcessSession session = sessionFactory.createSession();
        try {
            this.onTrigger(context, session);
            session.commit();
        }
        catch (Throwable t) {
            this.getLogger().error("{} failed to process due to {}; rolling back session", new Object[]{this, t});
            session.rollback(true);
            throw t;
        }
    }

    public abstract void onTrigger(ProcessContext var1, ProcessSession var2) throws ProcessException;
}

