/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.flume;

import java.util.ArrayList;
import java.util.List;
import org.apache.flume.Event;
import org.apache.flume.channel.BasicTransactionSemantics;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.flume.AbstractFlumeProcessor;
import org.apache.nifi.processors.flume.util.FlowFileEvent;

class NifiSinkTransaction
extends BasicTransactionSemantics {
    private final ProcessSession session;
    private final Relationship success;
    private final Relationship failure;
    private final List<FlowFile> flowFiles;

    public NifiSinkTransaction(ProcessSession session, Relationship success, Relationship failure) {
        this.session = session;
        this.success = success;
        this.failure = failure;
        this.flowFiles = new ArrayList<FlowFile>();
    }

    protected void doPut(Event event) throws InterruptedException {
        AbstractFlumeProcessor.transferEvent(event, this.session, this.success);
    }

    protected Event doTake() throws InterruptedException {
        FlowFile flowFile = this.session.get();
        if (flowFile == null) {
            return null;
        }
        this.flowFiles.add(flowFile);
        return new FlowFileEvent(flowFile, this.session);
    }

    protected void doCommit() throws InterruptedException {
        this.session.transfer(this.flowFiles, this.success);
        this.session.commit();
    }

    protected void doRollback() throws InterruptedException {
        this.session.transfer(this.flowFiles, this.failure);
        this.session.commit();
    }
}

