/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.parquet.record;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.processors.hadoop.record.HDFSRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.parquet.hadoop.ParquetWriter;

public class AvroParquetHDFSRecordWriter
implements HDFSRecordWriter {
    private final Schema avroSchema;
    private final ParquetWriter<GenericRecord> parquetWriter;

    public AvroParquetHDFSRecordWriter(ParquetWriter<GenericRecord> parquetWriter, Schema avroSchema) {
        this.avroSchema = avroSchema;
        this.parquetWriter = parquetWriter;
    }

    public void write(Record record) throws IOException {
        GenericRecord genericRecord = AvroTypeUtil.createAvroRecord((Record)record, (Schema)this.avroSchema);
        this.parquetWriter.write((Object)genericRecord);
    }

    public void close() throws IOException {
        this.parquetWriter.close();
    }
}

