/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.parquet.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.parquet.io.PositionOutputStream;

public class NifiOutputStream
extends PositionOutputStream {
    private long position = 0L;
    private OutputStream outputStream;

    public NifiOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public long getPos() throws IOException {
        return this.position;
    }

    public void write(int b) throws IOException {
        ++this.position;
        this.outputStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.position += (long)len;
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void close() throws IOException {
        this.outputStream.close();
    }
}

