/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority.impl;

import com.netflix.config.DynamicStringProperty;
import com.netflix.config.Property;
import com.netflix.config.PropertyWrapper;

public interface PropertyGetter<T> {
    public Property<T> getProperty(String var1, T var2);

    public static Property<String> getStringProperty(String propName, String defaultValue) {
        return new DynamicStringProperty(propName, defaultValue);
    }

    public static Property<Long> getLongProperty(String propName, Long defaultValue) {
        return new DynamicLongProperty(propName, defaultValue);
    }

    public static Property<Integer> getIntProperty(String propName, Integer defaultValue) {
        return new DynamicIntegerProperty(propName, defaultValue);
    }

    public static Property<Boolean> getBooleanProperty(String propName, Boolean defaultValue) {
        return new DynamicBooleanProperty(propName, defaultValue);
    }

    public static Property<Double> getDoubleProperty(String propName, Double defaultValue) {
        return new DynamicDoubleProperty(propName, defaultValue);
    }

    public static Property<Float> getFloatProperty(String propName, Float defaultValue) {
        return new DynamicFloatProperty(propName, defaultValue);
    }

    public static class DynamicFloatProperty
    extends PropertyWrapper<Float> {
        public DynamicFloatProperty(String propName, Float defaultValue) {
            super(propName, (Object)defaultValue);
        }

        public Float get() {
            return this.prop.getFloat((Float)this.defaultValue);
        }

        public Float getValue() {
            return this.get();
        }
    }

    public static class DynamicDoubleProperty
    extends PropertyWrapper<Double> {
        public DynamicDoubleProperty(String propName, Double defaultValue) {
            super(propName, (Object)defaultValue);
        }

        public Double get() {
            return this.prop.getDouble((Double)this.defaultValue);
        }

        public Double getValue() {
            return this.get();
        }
    }

    public static class DynamicBooleanProperty
    extends PropertyWrapper<Boolean> {
        public DynamicBooleanProperty(String propName, Boolean defaultValue) {
            super(propName, (Object)defaultValue);
        }

        public Boolean get() {
            return this.prop.getBoolean((Boolean)this.defaultValue);
        }

        public Boolean getValue() {
            return this.get();
        }
    }

    public static class DynamicIntegerProperty
    extends PropertyWrapper<Integer> {
        public DynamicIntegerProperty(String propName, Integer defaultValue) {
            super(propName, (Object)defaultValue);
        }

        public Integer get() {
            return this.prop.getInteger((Integer)this.defaultValue);
        }

        public Integer getValue() {
            return this.get();
        }
    }

    public static class DynamicLongProperty
    extends PropertyWrapper<Long> {
        public DynamicLongProperty(String propName, Long defaultValue) {
            super(propName, (Object)defaultValue);
        }

        public Long get() {
            return this.prop.getLong((Long)this.defaultValue);
        }

        public Long getValue() {
            return this.get();
        }
    }
}

