/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.io.xpp3.BundleListXpp3Reader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;

public abstract class AbstractBundleListMojo
extends AbstractMojo {
    protected File configDirectory;
    protected static final String JAR = "jar";
    protected static final String WAR = "war";
    protected static final String CONFIG_PATH_PREFIX = "resources/config";
    protected static final String BUNDLE_PATH_PREFIX = "resources/bundles";
    protected File bundleListFile;
    protected ArtifactDefinition defaultBundleList;
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    private ArtifactDefinition[] additionalBundles;
    private BundleList bundleList;
    private ArtifactDefinition[] bundleExclusions;
    private ArtifactFactory factory;
    private ArtifactMetadataSource metadataSource;
    private boolean includeDefaultBundles;
    private ArtifactRepository local;
    private List remoteRepos;
    private ArtifactResolver resolver;
    private File[] rewriteRuleFiles;
    protected MavenSession mavenSession;

    protected static boolean shouldCopy(File source, File dest) {
        if (!dest.exists()) {
            return true;
        }
        return source.lastModified() > dest.lastModified();
    }

    public final void execute() throws MojoFailureException, MojoExecutionException {
        try {
            this.initBundleList();
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load dependency information from properties file.", e);
        }
        this.executeWithArtifacts();
    }

    protected abstract void executeWithArtifacts() throws MojoExecutionException, MojoFailureException;

    protected Artifact getArtifact(ArtifactDefinition def) throws MojoExecutionException {
        return this.getArtifact(def.getGroupId(), def.getArtifactId(), def.getVersion(), def.getType(), def.getClassifier());
    }

    protected Artifact getArtifact(String groupId, String artifactId, String version, String type, String classifier) throws MojoExecutionException {
        VersionRange vr;
        try {
            vr = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            vr = VersionRange.createFromVersion((String)version);
        }
        Artifact artifact = StringUtils.isEmpty((String)classifier) ? this.factory.createDependencyArtifact(groupId, artifactId, vr, type, null, "compile") : this.factory.createDependencyArtifact(groupId, artifactId, vr, type, classifier, "compile");
        if (vr.getRecommendedVersion() == null) {
            try {
                List availVersions = this.metadataSource.retrieveAvailableVersions(artifact, this.local, this.remoteRepos);
                ArtifactVersion resolvedVersion = vr.matchVersion(availVersions);
                artifact.setVersion(resolvedVersion.toString());
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new MojoExecutionException("Unable to find version for artifact", (Exception)((Object)e));
            }
        }
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    protected BundleList getBundleList() {
        return this.bundleList;
    }

    protected void initArtifactDefinitions(Properties dependencies) {
    }

    protected void initBundleList(BundleList bundleList) {
    }

    protected boolean isCurrentArtifact(ArtifactDefinition def) {
        return def.getGroupId().equals(this.project.getGroupId()) && def.getArtifactId().equals(this.project.getArtifactId());
    }

    private final void initArtifactDefinitions() throws IOException {
        Properties dependencies = new Properties();
        dependencies.load(((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/sling/maven/projectsupport/dependencies.properties"));
        if (this.defaultBundleList == null) {
            this.defaultBundleList = new ArtifactDefinition();
        }
        this.defaultBundleList.initDefaults(dependencies.getProperty("defaultBundleList"));
        this.initArtifactDefinitions(dependencies);
    }

    private final void initBundleList() throws IOException, XmlPullParserException, MojoExecutionException {
        this.initArtifactDefinitions();
        if (this.isCurrentArtifact(this.defaultBundleList)) {
            this.bundleList = this.readBundleList(this.bundleListFile);
        } else {
            this.bundleList = new BundleList();
            if (this.includeDefaultBundles) {
                Artifact defBndListArtifact = this.getArtifact(this.defaultBundleList.getGroupId(), this.defaultBundleList.getArtifactId(), this.defaultBundleList.getVersion(), this.defaultBundleList.getType(), this.defaultBundleList.getClassifier());
                this.getLog().info((CharSequence)("Using bundle list file from " + defBndListArtifact.getFile().getAbsolutePath()));
                this.bundleList = this.readBundleList(defBndListArtifact.getFile());
            }
            if (this.bundleListFile.exists()) {
                this.bundleList.merge(this.readBundleList(this.bundleListFile));
            }
        }
        if (this.additionalBundles != null) {
            for (ArtifactDefinition def : this.additionalBundles) {
                this.bundleList.add(def.toBundle());
            }
        }
        if (this.bundleExclusions != null) {
            for (ArtifactDefinition def : this.bundleExclusions) {
                this.bundleList.remove(def.toBundle(), false);
            }
        }
        this.initBundleList(this.bundleList);
        this.rewriteBundleList(this.bundleList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteBundleList(BundleList bundleList) throws MojoExecutionException {
        if (this.rewriteRuleFiles != null) {
            KnowledgeBase knowledgeBase = this.createKnowledgeBase(this.rewriteRuleFiles);
            StatefulKnowledgeSession session = knowledgeBase.newStatefulKnowledgeSession();
            try {
                session.setGlobal("mavenSession", (Object)this.mavenSession);
                session.setGlobal("mavenProject", (Object)this.project);
                session.insert((Object)bundleList);
                session.fireAllRules();
            }
            finally {
                session.dispose();
            }
        }
    }

    private KnowledgeBase createKnowledgeBase(File[] files) throws MojoExecutionException {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newClassPathResource((String)"drools-globals.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        for (File file : files) {
            this.getLog().info((CharSequence)("Parsing rule file " + file.getAbsolutePath()));
            builder.add(ResourceFactory.newFileResource((File)file), ResourceType.DRL);
        }
        if (builder.hasErrors()) {
            this.getLog().error((CharSequence)"Rule errors:");
            for (KnowledgeBuilderError error : builder.getErrors()) {
                this.getLog().error((CharSequence)error.toString());
            }
            throw new MojoExecutionException("Unable to create rules. See log for details.");
        }
        KnowledgeBase base = KnowledgeBaseFactory.newKnowledgeBase();
        base.addKnowledgePackages(builder.getKnowledgePackages());
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleList readBundleList(File file) throws IOException, XmlPullParserException {
        BundleListXpp3Reader reader = new BundleListXpp3Reader();
        FileInputStream fis = new FileInputStream(file);
        try {
            BundleList bundleList = reader.read(fis);
            return bundleList;
        }
        finally {
            fis.close();
        }
    }
}

