/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.maven.projectsupport.AbstractLaunchpadStartingPlugin;

class ControlListener
implements Runnable {
    static final String COMMAND_STOP = "stop";
    static final String COMMAND_STATUS = "status";
    private static final String RESPONSE_OK = "OK";
    private static final int DEFAULT_LISTEN_PORT = 63000;
    private AbstractLaunchpadStartingPlugin mojo;
    private final Log log;
    private final SocketAddress socketAddress;

    ControlListener(AbstractLaunchpadStartingPlugin mojo, Log log, String host, int port) {
        this.mojo = mojo;
        this.log = log;
        this.socketAddress = this.getSocketAddress(host, port);
    }

    void listen() {
        if (this.socketAddress != null) {
            Thread listener = new Thread(this);
            listener.setDaemon(true);
            listener.setName("Sling Control Listener@" + this.socketAddress);
            listener.start();
        } else {
            this.log.info((CharSequence)"No socket address to listen to");
        }
    }

    void shutdownServer() {
        this.sendCommand(COMMAND_STOP);
    }

    void statusServer() {
        this.sendCommand(COMMAND_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServerSocket server = null;
        try {
            server = new ServerSocket();
            server.bind(this.socketAddress);
            this.log.info((CharSequence)("Sling Control Server started on " + this.socketAddress.toString()));
        }
        catch (IOException ioe) {
            this.log.error((CharSequence)"Failed to start Sling Control Server", (Throwable)ioe);
            return;
        }
        while (true) {
            try {
                try {
                    Socket s = server.accept();
                    try {
                        String command = this.readLine(s);
                        this.log.info((CharSequence)(s.getRemoteSocketAddress() + ">" + command));
                        if (COMMAND_STOP.equals(command)) {
                            if (this.mojo != null) {
                                this.mojo.stopSling();
                            }
                            this.writeLine(s, RESPONSE_OK);
                            this.log.info((CharSequence)"Sling shut down, stopping Sling.");
                            this.mojo.stopSling();
                            continue;
                        }
                        if (COMMAND_STATUS.equals(command)) {
                            this.writeLine(s, RESPONSE_OK);
                            continue;
                        }
                        this.writeLine(s, "ERR:" + command);
                    }
                    finally {
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException ioe) {
                    this.log.error((CharSequence)"Failure reading from client", (Throwable)ioe);
                    try {
                        server.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    server.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private SocketAddress getSocketAddress(String host, int port) {
        try {
            if (port == -1) {
                port = 63000;
            }
            if (host != null) {
                return new InetSocketAddress(host, port);
            }
            return new InetSocketAddress(InetAddress.getLocalHost(), port);
        }
        catch (UnknownHostException uhe) {
            this.log.error((CharSequence)("Unknown host in '" + host + "': " + uhe.getMessage()), null);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(String command) {
        if (this.socketAddress != null) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(this.socketAddress);
                this.writeLine(socket, command);
                String result = this.readLine(socket);
                this.log.info((CharSequence)("Sent '" + command + "' to " + this.socketAddress + ": " + result), null);
            }
            catch (ConnectException ce) {
                this.log.info((CharSequence)("No Sling running at " + this.socketAddress), null);
            }
            catch (IOException ioe) {
                this.log.error((CharSequence)("Failed sending '" + command + "' to " + this.socketAddress), (Throwable)ioe);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        } else {
            this.log.info((CharSequence)("No socket address to send '" + command + "' to"), null);
        }
    }

    private String readLine(Socket socket) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        return br.readLine();
    }

    private void writeLine(Socket socket, String line) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        bw.write(line);
        bw.write("\r\n");
        bw.flush();
    }
}

