/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.codehaus.plexus.util.StringUtils;

public class ArtifactDefinition {
    private String artifactId;
    private String classifier;
    private String groupId;
    private int startLevel;
    private String type;
    private String version;

    public ArtifactDefinition() {
    }

    public ArtifactDefinition(Bundle bundle, int startLevel) {
        this.groupId = bundle.getGroupId();
        this.artifactId = bundle.getArtifactId();
        this.type = bundle.getType();
        this.version = bundle.getVersion();
        this.classifier = bundle.getClassifier();
        this.startLevel = startLevel;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "AdditionalBundle [artifactId=" + this.artifactId + ", classifier=" + this.classifier + ", groupId=" + this.groupId + ", startLevel=" + this.startLevel + ", type=" + this.type + ", version=" + this.version + "]";
    }

    public void initDefaults(String commaDelimitedList) {
        String[] values = commaDelimitedList.split(",");
        if (values.length != 6) {
            throw new IllegalArgumentException(String.format("The string %s does not have the correct number of items (6).", commaDelimitedList));
        }
        this.initDefaults(values[0], values[1], values[2], values[3], values[4], Integer.valueOf(values[5]));
    }

    public void initDefaults(String groupId, String artifactId, String version, String type, String classifier, int startLevel) {
        if (this.groupId == null && StringUtils.isNotEmpty((String)groupId)) {
            this.groupId = groupId;
        }
        if (this.artifactId == null && StringUtils.isNotEmpty((String)artifactId)) {
            this.artifactId = artifactId;
        }
        if (this.version == null && StringUtils.isNotEmpty((String)version)) {
            this.version = version;
        }
        if (this.type == null && StringUtils.isNotEmpty((String)groupId)) {
            this.type = type;
        }
        if (this.classifier == null && StringUtils.isNotEmpty((String)classifier)) {
            this.classifier = classifier;
        }
        if (this.startLevel == 0) {
            this.startLevel = startLevel;
        }
    }

    public Bundle toBundle() {
        Bundle bnd = new Bundle();
        bnd.setArtifactId(this.artifactId);
        bnd.setGroupId(this.groupId);
        bnd.setVersion(this.version);
        if (this.type != null) {
            bnd.setType(this.type);
        }
        bnd.setClassifier(this.classifier);
        bnd.setStartLevel(this.startLevel);
        return bnd;
    }
}

