/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.settings.Settings;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.io.xpp3.BundleListXpp3Reader;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayBundleUpdatesMojo
extends AbstractMojo {
    private static final int INFO_PAD_SIZE = 72;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private MavenProjectBuilder projectBuilder;
    private List reactorProjects;
    private ArtifactMetadataSource artifactMetadataSource;
    private List remoteArtifactRepositories;
    private List remotePluginRepositories;
    private ArtifactRepository localRepository;
    private WagonManager wagonManager;
    private Settings settings;
    private String serverId;
    private String rulesUri;
    private MavenSession session;
    private PathTranslator pathTranslator;
    private File bundleListFile;
    private boolean allowSnapshots;
    private VersionsHelper helper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            BundleList bundleList = this.readBundleList(this.bundleListFile);
            HashSet<Dependency> bundlesAsDependencies = new HashSet<Dependency>();
            for (StartLevel startLevel : bundleList.getStartLevels()) {
                for (Bundle bundle : startLevel.getBundles()) {
                    bundlesAsDependencies.add(this.asDependency(bundle));
                }
            }
            this.logUpdates(this.getHelper().lookupDependenciesUpdates(bundlesAsDependencies, false));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to read bundle list.", e);
        }
    }

    private Dependency asDependency(Bundle bundle) {
        Dependency dep = new Dependency();
        dep.setGroupId(bundle.getGroupId());
        dep.setArtifactId(bundle.getArtifactId());
        dep.setClassifier(bundle.getClassifier());
        dep.setVersion(bundle.getVersion());
        dep.setType(bundle.getType());
        return dep;
    }

    private VersionsHelper getHelper() throws MojoExecutionException {
        if (this.helper == null) {
            this.helper = new DefaultVersionsHelper(this.artifactFactory, this.artifactMetadataSource, this.remoteArtifactRepositories, this.remotePluginRepositories, this.localRepository, this.wagonManager, this.settings, this.serverId, this.rulesUri, this.getLog(), this.session, this.pathTranslator);
        }
        return this.helper;
    }

    private void logUpdates(Map<Dependency, ArtifactVersions> updates) {
        ArrayList withUpdates = new ArrayList();
        ArrayList<String> usingCurrent = new ArrayList<String>();
        for (ArtifactVersions versions : updates.values()) {
            ArrayList<String> t;
            String left = "  " + ArtifactUtils.versionlessKey((Artifact)versions.getArtifact()) + " ";
            String current = versions.isCurrentVersionDefined() ? versions.getCurrentVersion().toString() : versions.getArtifact().getVersionRange().toString();
            ArtifactVersion latest = versions.getNewestUpdate(UpdateScope.ANY, Boolean.TRUE.equals(this.allowSnapshots));
            if (latest != null && !versions.isCurrentVersionDefined() && versions.getArtifact().getVersionRange().containsVersion(latest)) {
                latest = null;
            }
            String right = " " + (latest == null ? current : current + " -> " + latest.toString());
            ArrayList<String> arrayList = t = latest == null ? usingCurrent : withUpdates;
            if (right.length() + left.length() + 3 > 72) {
                t.add(left + "...");
                t.add(StringUtils.leftPad((String)right, (int)72));
                continue;
            }
            t.add(StringUtils.rightPad((String)left, (int)(72 - right.length()), (String)".") + right);
        }
        if (usingCurrent.isEmpty() && !withUpdates.isEmpty()) {
            this.getLog().info((CharSequence)"No bundles are using the newest version.");
            this.getLog().info((CharSequence)"");
        } else if (!usingCurrent.isEmpty()) {
            this.getLog().info((CharSequence)"The following bundles are using the newest version:");
            for (String str : usingCurrent) {
                this.getLog().info((CharSequence)str);
            }
            this.getLog().info((CharSequence)"");
        }
        if (withUpdates.isEmpty() && !usingCurrent.isEmpty()) {
            this.getLog().info((CharSequence)"No bundles have newer versions.");
            this.getLog().info((CharSequence)"");
        } else if (!withUpdates.isEmpty()) {
            this.getLog().info((CharSequence)"The following bundles have newer versions:");
            for (String str : withUpdates) {
                this.getLog().info((CharSequence)str);
            }
            this.getLog().info((CharSequence)"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleList readBundleList(File file) throws IOException, XmlPullParserException {
        BundleListXpp3Reader reader = new BundleListXpp3Reader();
        FileInputStream fis = new FileInputStream(file);
        try {
            BundleList bundleList = reader.read(fis);
            return bundleList;
        }
        finally {
            fis.close();
        }
    }
}

