/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport.bundlelist;

import java.util.List;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBundleList {
    public abstract List<StartLevel> getStartLevels();

    public Bundle get(Bundle bundle, boolean compareVersions) {
        for (StartLevel sl : this.getStartLevels()) {
            Bundle foundBundle = sl.getBundle(bundle, compareVersions);
            if (foundBundle == null) continue;
            return foundBundle;
        }
        return null;
    }

    public boolean remove(Bundle bundle, boolean compareVersions) {
        for (StartLevel sl : this.getStartLevels()) {
            if (!sl.removeBundle(bundle, compareVersions)) continue;
            return true;
        }
        return false;
    }

    public void merge(BundleList bundleList) {
        for (StartLevel sl : bundleList.getStartLevels()) {
            for (Bundle bnd : sl.getBundles()) {
                this.add(sl, bnd);
            }
        }
    }

    public void add(Bundle newBnd) {
        this.add(null, newBnd);
    }

    private void add(StartLevel mergeStartLevel, Bundle newBnd) {
        Bundle current = this.get(newBnd, false);
        if (current != null) {
            current.setVersion(newBnd.getVersion());
        } else {
            StartLevel startLevel = null;
            startLevel = mergeStartLevel == null || newBnd.getStartLevel() != 0 ? this.getOrCreateStartLevel(newBnd.getStartLevel()) : this.getOrCreateStartLevel(mergeStartLevel.getStartLevel());
            startLevel.getBundles().add(newBnd);
        }
    }

    private StartLevel getOrCreateStartLevel(int startLevel) {
        for (StartLevel sl : this.getStartLevels()) {
            if (sl.getStartLevel() != startLevel) continue;
            return sl;
        }
        StartLevel sl = new StartLevel();
        this.getStartLevels().add(sl);
        sl.setRawLevel(startLevel);
        return sl;
    }
}

