/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.sling.maven.projectsupport.AbstractBundleListMojo;
import org.apache.sling.maven.projectsupport.BundleListUtils;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.io.xpp3.BundleListXpp3Writer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class AttachPartialBundleListMojo
extends AbstractBundleListMojo {
    public static final String CONFIG_CLASSIFIER = "bundlelistconfig";
    public static final String CONFIG_TYPE = "zip";
    public static final String CLASSIFIER = "bundlelist";
    public static final String TYPE = "xml";
    public static final String SLING_COMMON_PROPS = "common.properties";
    public static final String SLING_COMMON_BOOTSTRAP = "common.bootstrap.txt";
    public static final String SLING_WEBAPP_PROPS = "webapp.properties";
    public static final String SLING_WEBAPP_BOOTSTRAP = "webapp.bootstrap.txt";
    public static final String SLING_STANDALONE_PROPS = "standalone.properties";
    public static final String SLING_STANDALONE_BOOTSTRAP = "standalone.bootstrap.txt";
    private File configOutputDir;
    private File bundleListOutput;
    private ZipArchiver zipArchiver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        BundleList initializedBundleList;
        if (this.bundleListFile.exists()) {
            try {
                initializedBundleList = BundleListUtils.readBundleList(this.bundleListFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read bundle list file", (Exception)e);
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Unable to read bundle list file", (Exception)((Object)e));
            }
        } else {
            throw new MojoFailureException(String.format("Bundle list file %s does not exist.", this.bundleListFile.getAbsolutePath()));
        }
        BundleListUtils.interpolateProperties(initializedBundleList, this.project, this.mavenSession);
        BundleListXpp3Writer writer = new BundleListXpp3Writer();
        try {
            writer.write(new FileWriter(this.bundleListOutput), initializedBundleList);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write bundle list", (Exception)e);
        }
        if (this.project.getPackaging().equals("partialbundlelist")) {
            this.project.getArtifact().setFile(this.bundleListOutput);
        } else {
            this.projectHelper.attachArtifact(this.project, TYPE, CLASSIFIER, this.bundleListOutput);
        }
        this.getLog().info((CharSequence)"Attaching bundle list configuration");
        try {
            this.attachConfigurations();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to attach configuration.", (Exception)ioe);
        }
        catch (ArchiverException ioe) {
            throw new MojoExecutionException("Unable to attach configuration.", (Exception)((Object)ioe));
        }
    }

    private boolean checkFile(File f) {
        return f != null && f.exists();
    }

    private void attachConfigurations() throws MojoExecutionException, IOException, ArchiverException {
        File slingDir;
        if (this.ignoreBundleListConfig) {
            this.getLog().debug((CharSequence)"ignoreBundleListConfig is set to true, therefore not attaching configurations.");
            return;
        }
        boolean hasConfigs = this.checkFile(this.getConfigDirectory());
        hasConfigs |= this.checkFile(this.commonSlingBootstrap);
        hasConfigs |= this.checkFile(this.commonSlingProps);
        hasConfigs |= this.checkFile(this.webappSlingBootstrap);
        hasConfigs |= this.checkFile(this.webappSlingProps);
        hasConfigs |= this.checkFile(this.standaloneSlingBootstrap);
        if (!(hasConfigs |= this.checkFile(this.standaloneSlingProps))) {
            this.getLog().debug((CharSequence)"No configurations to attach.");
            return;
        }
        this.configOutputDir.mkdirs();
        if (this.checkFile(this.commonSlingBootstrap)) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            FileUtils.copyFile((File)this.commonSlingBootstrap, (File)new File(slingDir, SLING_COMMON_BOOTSTRAP));
        }
        if (this.checkFile(this.commonSlingProps)) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            FileUtils.copyFile((File)this.commonSlingProps, (File)new File(slingDir, SLING_COMMON_PROPS));
        }
        if (this.checkFile(this.webappSlingBootstrap)) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            FileUtils.copyFile((File)this.webappSlingBootstrap, (File)new File(slingDir, SLING_WEBAPP_BOOTSTRAP));
        }
        if (this.checkFile(this.webappSlingProps)) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            FileUtils.copyFile((File)this.webappSlingProps, (File)new File(slingDir, SLING_WEBAPP_PROPS));
        }
        if (this.checkFile(this.standaloneSlingBootstrap)) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            FileUtils.copyFile((File)this.standaloneSlingBootstrap, (File)new File(slingDir, SLING_STANDALONE_BOOTSTRAP));
        }
        if (this.checkFile(this.standaloneSlingProps)) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            FileUtils.copyFile((File)this.standaloneSlingProps, (File)new File(slingDir, SLING_STANDALONE_PROPS));
        }
        if (this.checkFile(this.getConfigDirectory())) {
            File configDir = new File(this.configOutputDir, "config");
            configDir.mkdirs();
            FileUtils.copyDirectory((File)this.getConfigDirectory(), (File)configDir, null, (String)FileUtils.getDefaultExcludesAsString());
        }
        File destFile = new File(this.configOutputDir.getParent(), this.configOutputDir.getName() + ".zip");
        this.zipArchiver.setDestFile(destFile);
        this.zipArchiver.addDirectory(this.configOutputDir);
        this.zipArchiver.createArchive();
        this.projectHelper.attachArtifact(this.project, CONFIG_TYPE, CONFIG_CLASSIFIER, destFile);
    }
}

