/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.sling.maven.projectsupport.AbstractLaunchpadFrameworkMojo;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

public class PreparePackageMojo
extends AbstractLaunchpadFrameworkMojo {
    private File warOutputDirectory;
    private String packaging;
    private ArtifactDefinition base;
    private ArtifactDefinition jarWebSupport;
    private File buildOutputDirectory;
    private File tempDirectory;
    private ArchiverManager archiverManager;
    private JarArchiver jarArchiver;

    public void executeWithArtifacts() throws MojoExecutionException, MojoFailureException {
        this.copyBaseArtifact();
        this.copyBundles(this.getInitializedBundleList(), this.getOutputDirectory());
        this.copyConfigurationFiles();
        if ("jar".equals(this.packaging)) {
            this.unpackBaseArtifact();
        }
    }

    protected void initArtifactDefinitions(Properties dependencies) {
        if (this.base == null) {
            this.base = new ArtifactDefinition();
        }
        this.base.initDefaults(dependencies.getProperty("base"));
        if (this.jarWebSupport == null) {
            this.jarWebSupport = new ArtifactDefinition();
        }
        this.jarWebSupport.initDefaults(dependencies.getProperty("jarWebSupport"));
    }

    protected void initBundleList(BundleList bundleList) {
        if (this.packaging.equals("jar")) {
            bundleList.add(this.jarWebSupport.toBundle());
        }
    }

    private void patchSlingProperties(File dest, Properties additionalProps) throws MojoExecutionException {
        File origSlingProps = new File(dest, "sling.properties");
        if (!origSlingProps.exists()) {
            throw new MojoExecutionException("sling.properties not found at " + origSlingProps);
        }
        Properties orig = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(origSlingProps);
            orig.load(fis);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to read " + origSlingProps, (Exception)ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignore) {}
            }
        }
        Enumeration<Object> keys = additionalProps.keys();
        if (keys.hasMoreElements()) {
            this.getLog().info((CharSequence)"Patching sling.properties");
        }
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            orig.put(key, additionalProps.get(key));
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(origSlingProps);
            orig.store(fos, null);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to save " + origSlingProps, (Exception)ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private void patchSlingBootstrap(File dest, String additionalCmd) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Patching sling_bootstrap.txt");
        File origSlingCmd = new File(dest, "sling_bootstrap.txt");
        FileWriter writer = null;
        try {
            writer = new FileWriter(origSlingCmd);
            writer.write(additionalCmd);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to save " + origSlingCmd, (Exception)ioe);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBaseArtifact() throws MojoExecutionException {
        Artifact artifact = this.getBaseArtifact();
        if (artifact == null) {
            throw new MojoExecutionException(String.format("Project doesn't have a base dependency of groupId %s and artifactId %s", this.base.getGroupId(), this.base.getArtifactId()));
        }
        File destinationDir = new File(this.getOutputDirectory(), this.baseDestination);
        File destinationFile = new File(destinationDir, artifact.getArtifactId() + "." + artifact.getArtifactHandler().getExtension());
        Properties additionalProps = this.getSlingProperties("jar".equals(this.packaging));
        String bootstrapCmd = this.getSlingBootstrap("jar".equals(this.packaging));
        if (additionalProps != null || bootstrapCmd != null) {
            File dest = new File(this.tempDirectory, "basejar");
            try {
                this.unpack(artifact.getFile(), dest);
                if (additionalProps != null) {
                    this.patchSlingProperties(dest, additionalProps);
                }
                if (bootstrapCmd != null) {
                    this.patchSlingBootstrap(dest, bootstrapCmd);
                }
                this.pack(dest, destinationFile);
            }
            finally {
                this.tempDirectory.delete();
            }
        } else if (PreparePackageMojo.shouldCopy(artifact.getFile(), destinationFile)) {
            try {
                this.getLog().info((CharSequence)String.format("Copying base artifact from %s to %s.", artifact.getFile(), destinationFile));
                FileUtils.copyFile((File)artifact.getFile(), (File)destinationFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy base artifact.", (Exception)e);
            }
        } else {
            this.getLog().debug((CharSequence)String.format("Skipping copy of base artifact from %s.", artifact.getFile()));
        }
    }

    private Artifact getBaseArtifact() throws MojoExecutionException {
        Artifact baseDependency = this.getBaseDependency();
        if (baseDependency == null) {
            return null;
        }
        return this.getArtifact(this.base.getGroupId(), this.base.getArtifactId(), baseDependency.getVersion(), this.base.getType(), this.base.getClassifier());
    }

    private Artifact getBaseDependency() {
        return (Artifact)this.project.getArtifactMap().get(this.base.getGroupId() + ":" + this.base.getArtifactId());
    }

    protected File getOutputDirectory() {
        if ("war".equals(this.packaging)) {
            return this.warOutputDirectory;
        }
        return this.buildOutputDirectory;
    }

    protected void unpackBaseArtifact() throws MojoExecutionException {
        Artifact artifact = this.getBaseDependency();
        if (artifact == null) {
            throw new MojoExecutionException(String.format("Project doesn't have a base dependency of groupId %s and artifactId %s", this.base.getGroupId(), this.base.getArtifactId()));
        }
        this.unpack(artifact.getFile(), this.buildOutputDirectory);
    }

    private void copyConfigurationFiles() throws MojoExecutionException {
        try {
            FileUtils.copyDirectory((File)this.getConfigDirectory(), (File)new File(this.getOutputDirectory(), "resources/config"), null, (String)FileUtils.getDefaultExcludesAsString());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy configuration files", (Exception)e);
        }
    }

    private void unpack(File source, File destination) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Unpacking " + source.getPath() + " to\n  " + destination.getPath()));
        try {
            destination.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(source);
            unArchiver.setSourceFile(source);
            unArchiver.setDestDirectory(destination);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unable to find archiver for " + source.getPath(), (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to unpack " + source.getPath(), (Exception)((Object)e));
        }
    }

    private void pack(File sourceDir, File destination) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Packing " + sourceDir.getPath() + " to\n  " + destination.getPath()));
        try {
            destination.getParentFile().mkdirs();
            this.jarArchiver.setDestFile(destination);
            this.jarArchiver.addDirectory(sourceDir);
            this.jarArchiver.setManifest(new File(sourceDir, "META-INF/MANIFEST.MF".replace('/', File.separatorChar)));
            this.jarArchiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to pack " + sourceDir.getPath(), (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to pack " + sourceDir.getPath(), (Exception)((Object)e));
        }
    }
}

