/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.framework.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.launchpad.base.impl.Sling;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.apache.sling.maven.projectsupport.AbstractUsingBundleListMojo;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLaunchpadStartingMojo
extends AbstractUsingBundleListMojo
implements Notifiable {
    private static final int DEFAULT_LOG_LEVEL = 3;
    private static final String[] logLevels = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG"};
    private static final String PROP_PORT = "org.osgi.service.http.port";
    private int httpPort;
    private ArtifactDefinition jarWebSupport;
    private String logLevel;
    private File propertiesFile;
    private File resourceProviderRoot;
    private LaunchpadContentProvider resourceProvider = new LaunchpadContentProvider(){

        public Iterator<String> getChildren(String path) {
            if (path.equals("resources/bundles")) {
                HashSet<String> levels = new HashSet<String>();
                for (StartLevel level : AbstractLaunchpadStartingMojo.this.getInitializedBundleList().getStartLevels()) {
                    if (level.getStartLevel() == -1) {
                        levels.add("resources/bundles/1/");
                        continue;
                    }
                    levels.add("resources/bundles/" + level.getLevel() + "/");
                }
                return levels.iterator();
            }
            if (path.equals("resources/corebundles")) {
                List empty = Collections.emptyList();
                return empty.iterator();
            }
            if (path.equals("resources/config")) {
                if (AbstractLaunchpadStartingMojo.this.getConfigDirectory().exists() && AbstractLaunchpadStartingMojo.this.getConfigDirectory().isDirectory()) {
                    File[] configFiles = AbstractLaunchpadStartingMojo.this.getConfigDirectory().listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isFile();
                        }
                    });
                    ArrayList<String> fileNames = new ArrayList<String>();
                    for (File cfgFile : configFiles) {
                        if (!cfgFile.isFile()) continue;
                        fileNames.add("resources/config/" + cfgFile.getName());
                    }
                    return fileNames.iterator();
                }
                List empty = Collections.emptyList();
                return empty.iterator();
            }
            if (path.startsWith("resources/bundles")) {
                String startLevelInfo = path.substring("resources/bundles".length() + 1);
                try {
                    int startLevel = Integer.parseInt(startLevelInfo);
                    ArrayList<String> bundles = new ArrayList<String>();
                    for (StartLevel level : AbstractLaunchpadStartingMojo.this.getInitializedBundleList().getStartLevels()) {
                        if (level.getStartLevel() != startLevel && (startLevel != 1 || level.getStartLevel() != -1)) continue;
                        for (Bundle bundle : level.getBundles()) {
                            ArtifactDefinition d = new ArtifactDefinition(bundle, startLevel);
                            try {
                                Artifact artifact = AbstractLaunchpadStartingMojo.this.getArtifact(d);
                                bundles.add(artifact.getFile().toURI().toURL().toExternalForm());
                            }
                            catch (Exception e) {
                                AbstractLaunchpadStartingMojo.this.getLog().error((CharSequence)"Unable to resolve artifact ", (Throwable)e);
                            }
                        }
                    }
                    return bundles.iterator();
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (path.equals("resources")) {
                HashSet<String> subDirs = new HashSet<String>();
                subDirs.add("resources/bundles");
                subDirs.add("resources/config");
                subDirs.add("resources/corebundles");
                return subDirs.iterator();
            }
            AbstractLaunchpadStartingMojo.this.getLog().warn((CharSequence)("un-handlable path " + path));
            return null;
        }

        public URL getResource(String path) {
            File resourceFile;
            File configFile;
            if (path.startsWith("resources/config") && (configFile = new File(AbstractLaunchpadStartingMojo.this.getConfigDirectory(), path.substring("resources/config".length() + 1))).exists()) {
                try {
                    return configFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if ((resourceFile = new File(AbstractLaunchpadStartingMojo.this.resourceProviderRoot, path)).exists()) {
                try {
                    return resourceFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    AbstractLaunchpadStartingMojo.this.getLog().error((CharSequence)"Unable to create URL for file", (Throwable)e);
                    return null;
                }
            }
            URL fromClasspath = this.getClass().getResource("/" + path);
            if (fromClasspath != null) {
                return fromClasspath;
            }
            try {
                return new URL(path);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        public InputStream getResourceAsStream(String path) {
            URL res = this.getResource(path);
            if (res != null) {
                try {
                    return res.openStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    private Sling sling;
    private String slingHome;
    private boolean forceBundleLoad;

    private static int toLogLevelInt(String level, int defaultLevel) {
        for (int i = 0; i < logLevels.length; ++i) {
            if (!logLevels[i].equalsIgnoreCase(level)) continue;
            return i;
        }
        return defaultLevel;
    }

    public void stopped() {
        this.sling = null;
    }

    public void updated(File updateFile) {
        this.sling = null;
        if (updateFile != null) {
            this.getLog().warn((CharSequence)"Maven Launchpad Plugin doesn't support updating the framework bundle.");
        }
        this.getLog().info((CharSequence)"Restarting Framework and Sling");
        try {
            this.executeWithArtifacts();
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Unable to restart Framework and Sling", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    protected void executeWithArtifacts() throws MojoExecutionException {
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sling.home", this.slingHome);
            props.put("sling.launchpad", this.slingHome);
            if (this.forceBundleLoad) {
                props.put("org.apache.sling.launchpad.force.package.bundle.loading", "true");
            }
            int logLevelNum = this.logLevel == null ? 3 : AbstractLaunchpadStartingMojo.toLogLevelInt(this.logLevel, 3);
            props.put("felix.log.level", String.valueOf(logLevelNum));
            this.getLog().info((CharSequence)("HTTP server port: " + this.httpPort));
            props.put(PROP_PORT, String.valueOf(this.httpPort));
            Logger logger = new Logger();
            logger.setLogLevel(1);
            if (this.propertiesFile.exists()) {
                File tmp = null;
                try {
                    tmp = File.createTempFile("sling", "props");
                    this.mavenFileFilter.copyFile(this.propertiesFile, tmp, true, this.project, null, true, System.getProperty("file.encoding"), this.mavenSession);
                    Properties loadedProps = PropertyUtils.loadPropertyFile((File)tmp, null);
                    for (Object key : loadedProps.keySet()) {
                        props.put((String)key, (String)loadedProps.get(key));
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to create filtered properties file", (Exception)e);
                }
                catch (MavenFilteringException e) {
                    throw new MojoExecutionException("Unable to create filtered properties file", (Exception)((Object)e));
                }
                finally {
                    if (tmp != null) {
                        tmp.delete();
                    }
                }
            }
            this.sling = this.startSling(this.resourceProvider, props, logger);
        }
        catch (BundleException be) {
            this.getLog().error((CharSequence)"Failed to Start OSGi framework", (Throwable)be);
        }
    }

    protected abstract Sling startSling(LaunchpadContentProvider var1, Map<String, String> var2, Logger var3) throws BundleException;

    protected void stopSling() {
        if (this.sling != null) {
            this.sling.destroy();
        }
    }

    @Override
    protected void initArtifactDefinitions(Properties dependencies) {
        if (this.jarWebSupport == null) {
            this.jarWebSupport = new ArtifactDefinition();
        }
        this.jarWebSupport.initDefaults(dependencies.getProperty("jarWebSupport"));
    }

    @Override
    protected void initBundleList(BundleList bundleList) {
        bundleList.add(this.jarWebSupport.toBundle());
    }
}

