/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.BundleListUtils;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class LaunchpadPluginLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String PLUGIN_ID = "maven-launchpad-plugin";
    private static final String PROVIDED = "provided";
    @Requirement
    private Logger log;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
            for (MavenProject project : session.getProjects()) {
                projectMap.put(project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion(), project);
            }
            for (MavenProject project : session.getProjects()) {
                for (Plugin plugin : project.getBuild().getPlugins()) {
                    if (!plugin.getArtifactId().equals(PLUGIN_ID)) continue;
                    BundleListDependencyAdder performer = new BundleListDependencyAdder(session, project, plugin);
                    performer.addDependencies();
                }
            }
        }
        catch (Exception e) {
            throw new MavenExecutionException("Unable to determine launchpad plugin-based dependencies", (Throwable)e);
        }
        super.afterProjectsRead(session);
    }

    private class BundleListDependencyAdder {
        private final MavenSession session;
        private final MavenProject project;
        private final Plugin plugin;
        private final List<ArtifactDefinition> additionalBundles;
        private ArtifactDefinition defaultBundleList;
        private boolean includeDefaultBundles;
        private ArtifactDefinition jarWebSupport;
        private File bundleListFile;

        public BundleListDependencyAdder(MavenSession session, MavenProject project, Plugin plugin) {
            this.session = session;
            this.project = project;
            this.plugin = plugin;
            this.additionalBundles = new ArrayList<ArtifactDefinition>();
        }

        void addDependencies() throws Exception {
            this.readConfiguration();
            this.addBundleListDependencies();
            if (this.hasPreparePackageExecution()) {
                if (this.includeDefaultBundles && !BundleListUtils.isCurrentArtifact(this.project, this.defaultBundleList)) {
                    LaunchpadPluginLifecycleParticipant.this.log.debug(String.format("adding default bundle list (%s) to dependencies of project %s", this.defaultBundleList, this.project));
                    this.project.getDependencies().add(this.defaultBundleList.toDependency(LaunchpadPluginLifecycleParticipant.PROVIDED));
                }
                if (this.hasJarPackagingExecution()) {
                    LaunchpadPluginLifecycleParticipant.this.log.debug(String.format("adding jar web support (%s) to dependencies of project %s", this.jarWebSupport, this.project));
                    this.project.getDependencies().add(this.jarWebSupport.toDependency(LaunchpadPluginLifecycleParticipant.PROVIDED));
                }
            }
        }

        private void addBundleListDependencies() throws IOException, XmlPullParserException, MojoExecutionException {
            BundleList bundleList = this.bundleListFile.exists() ? BundleListUtils.readBundleList(this.bundleListFile) : new BundleList();
            if (this.additionalBundles != null) {
                for (ArtifactDefinition def : this.additionalBundles) {
                    bundleList.add(def.toBundle());
                }
            }
            BundleListUtils.interpolateProperties(bundleList, this.project, this.session);
            for (StartLevel startLevel : bundleList.getStartLevels()) {
                for (Bundle bundle : startLevel.getBundles()) {
                    LaunchpadPluginLifecycleParticipant.this.log.debug(String.format("adding bundle (%s) from bundle list to dependencies of project %s", bundle, this.project));
                    this.project.getDependencies().add(ArtifactDefinition.toDependency(bundle, LaunchpadPluginLifecycleParticipant.PROVIDED));
                }
            }
        }

        private void readConfiguration() throws IOException {
            Xpp3Dom configuration = (Xpp3Dom)this.plugin.getConfiguration();
            this.defaultBundleList = null;
            this.jarWebSupport = null;
            this.includeDefaultBundles = true;
            this.bundleListFile = new File(this.project.getBasedir(), "src/main/bundles/list.xml");
            if (configuration != null) {
                Xpp3Dom bundleListFileConfig;
                Xpp3Dom jarWebSupportConfig;
                this.includeDefaultBundles = BundleListUtils.nodeValue(configuration, "includeDefaultBundles", true);
                Xpp3Dom defaultBundleListConfig = configuration.getChild("defaultBundleList");
                if (defaultBundleListConfig != null) {
                    this.defaultBundleList = new ArtifactDefinition(defaultBundleListConfig);
                }
                if ((jarWebSupportConfig = configuration.getChild("jarWebSupport")) != null) {
                    this.jarWebSupport = new ArtifactDefinition(jarWebSupportConfig);
                }
                if ((bundleListFileConfig = configuration.getChild("bundleListFile")) != null) {
                    this.bundleListFile = new File(this.project.getBasedir(), bundleListFileConfig.getValue());
                }
                this.configureAdditionalBundles(configuration);
            }
            for (PluginExecution execution : this.plugin.getExecutions()) {
                Xpp3Dom executionConfiguration = (Xpp3Dom)execution.getConfiguration();
                if (executionConfiguration == null) continue;
                this.configureAdditionalBundles(executionConfiguration);
            }
            BundleListUtils.initArtifactDefinitions(this.getClass().getClassLoader(), new BundleListUtils.ArtifactDefinitionsCallback(){

                public void initArtifactDefinitions(Properties dependencies) {
                    if (BundleListDependencyAdder.this.defaultBundleList == null) {
                        BundleListDependencyAdder.this.defaultBundleList = new ArtifactDefinition();
                    }
                    BundleListDependencyAdder.this.defaultBundleList.initDefaults(dependencies.getProperty("defaultBundleList"));
                    if (BundleListDependencyAdder.this.jarWebSupport == null) {
                        BundleListDependencyAdder.this.jarWebSupport = new ArtifactDefinition();
                    }
                    BundleListDependencyAdder.this.jarWebSupport.initDefaults(dependencies.getProperty("jarWebSupport"));
                }
            });
        }

        private void configureAdditionalBundles(Xpp3Dom configuration) {
            Xpp3Dom[] bundleConfigs;
            Xpp3Dom additionalBundlesConfig = configuration.getChild("additionalBundles");
            if (additionalBundlesConfig != null && (bundleConfigs = additionalBundlesConfig.getChildren("bundle")) != null) {
                for (Xpp3Dom bundleConfig : bundleConfigs) {
                    this.additionalBundles.add(new ArtifactDefinition(bundleConfig));
                }
            }
        }

        private boolean hasJarPackagingExecution() {
            if ("jar".equals(this.project.getPackaging())) {
                return true;
            }
            for (PluginExecution execution : this.plugin.getExecutions()) {
                Xpp3Dom packagingConfig;
                Xpp3Dom executionConfig;
                if (!execution.getGoals().contains("prepare-package") || (executionConfig = (Xpp3Dom)execution.getConfiguration()) == null || (packagingConfig = executionConfig.getChild("packaging")) == null || !"jar".equals(packagingConfig.getValue())) continue;
                return true;
            }
            return false;
        }

        private boolean hasPreparePackageExecution() {
            for (PluginExecution execution : this.plugin.getExecutions()) {
                if (!execution.getGoals().contains("prepare-package")) continue;
                return true;
            }
            return false;
        }
    }
}

