/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractBundleListMojo
extends AbstractMojo {
    protected static final String PARTIAL = "partialbundlelist";
    protected File bundleListFile;
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    private File configDirectory;
    protected File commonSlingProps;
    protected File commonSlingBootstrap;
    protected File webappSlingProps;
    protected File webappSlingBootstrap;
    protected File standaloneSlingProps;
    protected File standaloneSlingBootstrap;
    protected boolean ignoreBundleListConfig;
    protected MavenSession mavenSession;
    private ArtifactFactory factory;
    private ArtifactMetadataSource metadataSource;
    private ArtifactRepository local;
    private List<ArtifactRepository> remoteRepos;
    private ArtifactResolver resolver;

    protected File getConfigDirectory() {
        return this.configDirectory;
    }

    protected Artifact getArtifact(ArtifactDefinition def) throws MojoExecutionException {
        return this.getArtifact(def.getGroupId(), def.getArtifactId(), def.getVersion(), def.getType(), def.getClassifier());
    }

    protected Artifact getArtifact(String groupId, String artifactId, String version, String type, String classifier) throws MojoExecutionException {
        VersionRange vr;
        try {
            vr = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            vr = VersionRange.createFromVersion((String)version);
        }
        Artifact artifact = StringUtils.isEmpty((String)classifier) ? this.factory.createDependencyArtifact(groupId, artifactId, vr, type, null, "compile") : this.factory.createDependencyArtifact(groupId, artifactId, vr, type, classifier, "compile");
        if (vr.getRecommendedVersion() == null) {
            try {
                List availVersions = this.metadataSource.retrieveAvailableVersions(artifact, this.local, this.remoteRepos);
                ArtifactVersion resolvedVersion = vr.matchVersion(availVersions);
                artifact.setVersion(resolvedVersion.toString());
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new MojoExecutionException("Unable to find version for artifact", (Exception)((Object)e));
            }
        }
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    protected void copyDirectory(File source, File target, final String[] includes, final String[] excludes) throws IOException {
        String prefix = source.getAbsolutePath() + File.separatorChar;
        final int prefixLength = prefix.length();
        FileUtils.copyDirectory((File)source, (File)target, (FileFilter)new FileFilter(){

            public boolean accept(File file) {
                String path = file.getAbsolutePath().substring(prefixLength).replace(File.separatorChar, '/');
                if (includes != null) {
                    boolean matched = false;
                    for (int i = 0; i < includes.length && !matched; ++i) {
                        if (!SelectorUtils.matchPath((String)includes[i], (String)path)) continue;
                        matched = true;
                    }
                    if (!matched) {
                        return false;
                    }
                }
                if (excludes != null) {
                    for (String pattern : excludes) {
                        if (!SelectorUtils.matchPath((String)pattern, (String)path)) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }
}

