/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.maven.projectsupport.AbstractUsingBundleListMojo;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractLaunchpadFrameworkMojo
extends AbstractUsingBundleListMojo {
    protected String baseDestination;
    private String bundlesDirectory;
    private String bootDirectory;

    protected String getPathForArtifact(int startLevel, String artifactName, String runModes) {
        String runModeExt;
        TreeSet<String> runModesList = new TreeSet<String>();
        if (runModes != null) {
            for (String mode : runModes.split(",")) {
                if (mode.trim().length() <= 0) continue;
                runModesList.add(mode);
            }
        }
        if (runModesList.size() == 0) {
            runModeExt = "";
        } else {
            StringBuilder sb = new StringBuilder();
            for (String n : runModesList) {
                sb.append('.');
                sb.append(n);
            }
            runModeExt = sb.toString();
        }
        if (startLevel == -1 && this.bootDirectory != null) {
            return String.format("%s/%s%s/1/%s", this.baseDestination, this.bootDirectory, runModeExt, artifactName);
        }
        return String.format("%s/%s%s/%s/%s", this.baseDestination, this.bundlesDirectory, runModeExt, startLevel == -1 ? 1 : startLevel, artifactName, runModeExt);
    }

    protected void copyBundles(BundleList bundles, File outputDirectory) throws MojoExecutionException {
        for (StartLevel startLevel : bundles.getStartLevels()) {
            for (Bundle bundle : startLevel.getBundles()) {
                this.copy(new ArtifactDefinition(bundle, startLevel.getStartLevel()), outputDirectory);
            }
        }
    }

    protected void copy(ArtifactDefinition additionalBundle, File outputDirectory) throws MojoExecutionException {
        Artifact artifact = this.getArtifact(additionalBundle);
        this.copy(artifact.getFile(), additionalBundle.getStartLevel(), additionalBundle.getRunModes(), outputDirectory);
    }

    protected void copy(File file, int startLevel, String runModes, File outputDirectory) throws MojoExecutionException {
        File destination = new File(outputDirectory, this.getPathForArtifact(startLevel, file.getName().replace('/', File.separatorChar), runModes));
        if (AbstractLaunchpadFrameworkMojo.shouldCopy(file, destination)) {
            this.getLog().info((CharSequence)String.format("Copying bundle from %s to %s", file.getPath(), destination.getPath()));
            try {
                FileUtils.copyFile((File)file, (File)destination);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy bundle from " + file.getPath(), (Exception)e);
            }
        }
    }
}

