/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class BundleListXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, BundleList bundleList) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(bundleList.getModelEncoding(), null);
        this.writeBundleList(bundleList, "bundles", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeBundle(Bundle bundle, String tagName, XmlSerializer serializer) throws IOException {
        if (bundle != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (bundle.getGroupId() != null) {
                serializer.startTag(NAMESPACE, "groupId").text(bundle.getGroupId()).endTag(NAMESPACE, "groupId");
            }
            if (bundle.getArtifactId() != null) {
                serializer.startTag(NAMESPACE, "artifactId").text(bundle.getArtifactId()).endTag(NAMESPACE, "artifactId");
            }
            if (bundle.getVersion() != null) {
                serializer.startTag(NAMESPACE, "version").text(bundle.getVersion()).endTag(NAMESPACE, "version");
            }
            if (bundle.getType() != null && !bundle.getType().equals("jar")) {
                serializer.startTag(NAMESPACE, "type").text(bundle.getType()).endTag(NAMESPACE, "type");
            }
            if (bundle.getClassifier() != null) {
                serializer.startTag(NAMESPACE, "classifier").text(bundle.getClassifier()).endTag(NAMESPACE, "classifier");
            }
            if (bundle.getStartLevel() != 0) {
                serializer.startTag(NAMESPACE, "startLevel").text(String.valueOf(bundle.getStartLevel())).endTag(NAMESPACE, "startLevel");
            }
            if (bundle.getRunModes() != null) {
                serializer.startTag(NAMESPACE, "runModes").text(bundle.getRunModes()).endTag(NAMESPACE, "runModes");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeBundleList(BundleList bundleList, String tagName, XmlSerializer serializer) throws IOException {
        if (bundleList != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (bundleList.getStartLevels() != null && bundleList.getStartLevels().size() > 0) {
                for (StartLevel o : bundleList.getStartLevels()) {
                    this.writeStartLevel(o, "startLevel", serializer);
                }
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeStartLevel(StartLevel startLevel, String tagName, XmlSerializer serializer) throws IOException {
        if (startLevel != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (startLevel.getLevel() != null) {
                serializer.attribute(NAMESPACE, "level", startLevel.getLevel());
            }
            if (startLevel.getBundles() != null && startLevel.getBundles().size() > 0) {
                for (Bundle o : startLevel.getBundles()) {
                    this.writeBundle(o, "bundle", serializer);
                }
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }
}

