/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.sling.maven.projectsupport.AbstractUsingBundleListMojo;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class CreateKarafFeatureDescriptorMojo
extends AbstractUsingBundleListMojo {
    private static final String CLASSIFIER = "features";
    private static final String TYPE = "xml";
    private String featureName;
    private String featuresName;
    private String featureVersion;
    private File outputFile;

    protected void executeWithArtifacts() throws MojoExecutionException, MojoFailureException {
        Document doc = new Document();
        Element features = new Element(CLASSIFIER);
        doc.setRootElement(features);
        features.setAttribute("name", this.featuresName);
        Element feature = new Element("feature");
        features.addContent((Content)feature);
        feature.setAttribute("name", this.featureName);
        feature.setAttribute("version", this.featureVersion);
        BundleList bundleList = this.getInitializedBundleList();
        for (StartLevel level : bundleList.getStartLevels()) {
            for (Bundle bundle : level.getBundles()) {
                String bundleRef = String.format("mvn:%s/%s/%s", bundle.getGroupId(), bundle.getArtifactId(), bundle.getVersion());
                feature.addContent((Content)new Element("bundle").setText(bundleRef));
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.outputFile);
            new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8")).output(doc, (OutputStream)out);
            this.projectHelper.attachArtifact(this.project, TYPE, CLASSIFIER, this.outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write features.xml", (Exception)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

