/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport.bundlelist;

import java.util.List;
import org.apache.maven.shared.osgi.DefaultMaven2OsgiConverter;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBundleList {
    public abstract List<StartLevel> getStartLevels();

    public Bundle get(Bundle bundle, boolean compareVersions) {
        for (StartLevel sl : this.getStartLevels()) {
            Bundle foundBundle = sl.getBundle(bundle, compareVersions);
            if (foundBundle == null) continue;
            return foundBundle;
        }
        return null;
    }

    public boolean remove(List<Bundle> bundles, boolean compareVersions) {
        boolean result = false;
        block0: for (Bundle bundle : bundles) {
            for (StartLevel sl : this.getStartLevels()) {
                if (!sl.removeBundle(bundle, compareVersions)) continue;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    public void merge(BundleList bundleList) {
        for (StartLevel sl : bundleList.getStartLevels()) {
            for (Bundle bnd : sl.getBundles()) {
                this.add(sl, bnd);
            }
        }
    }

    public void add(List<Bundle> newBnd) {
        for (Bundle bundle : newBnd) {
            this.add(null, bundle);
        }
    }

    private void add(StartLevel mergeStartLevel, Bundle newBnd) {
        Bundle current = this.get(newBnd, false);
        if (current != null) {
            Version oldVersion;
            DefaultMaven2OsgiConverter converter = new DefaultMaven2OsgiConverter();
            Version newVersion = new Version(converter.getVersion(newBnd.getVersion()));
            if (newVersion.compareTo((Object)(oldVersion = new Version(converter.getVersion(current.getVersion())))) > 0) {
                current.setVersion(newBnd.getVersion());
            }
        } else {
            StartLevel startLevel = null;
            startLevel = mergeStartLevel == null || newBnd.getStartLevel() != 0 ? this.getOrCreateStartLevel(newBnd.getStartLevel()) : this.getOrCreateStartLevel(mergeStartLevel.getStartLevel());
            startLevel.getBundles().add(newBnd);
        }
    }

    private StartLevel getOrCreateStartLevel(int startLevel) {
        for (StartLevel sl : this.getStartLevels()) {
            if (sl.getStartLevel() != startLevel) continue;
            return sl;
        }
        StartLevel sl = new StartLevel();
        this.getStartLevels().add(sl);
        sl.setRawLevel(startLevel);
        return sl;
    }
}

