/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.samples.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Properties(value={@Property(name="hc.name"), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY), @Property(name="hc.mbean.name"), @Property(name="scheduler.period", longValue={5L}, propertyPrivate=true), @Property(name="scheduler.concurrent", boolValue={false})})
@Service(value={HealthCheck.class, Runnable.class})
public class AsyncHealthCheckSample
implements HealthCheck,
Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger counter = new AtomicInteger();
    public static final int PERIOD_SECONDS = 5;

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        int value = this.counter.get();
        resultLog.debug("{} - counter value is {}", new Object[]{this, value});
        if (value % 2 != 0) {
            resultLog.warn("Counter value ({}) is not even", new Object[]{value});
        }
        return new Result((ResultLog)resultLog);
    }

    @Override
    public void run() {
        long toWait = (long)(Math.random() * 2.0 * 5.0);
        this.log.info("{} - Waiting {} seconds to simulate an expensive operation...", (Object)this, (Object)toWait);
        try {
            Thread.sleep(toWait * 1000L);
        }
        catch (InterruptedException iex) {
            this.log.warn("Sleep interrupted", (Throwable)iex);
        }
        this.counter.incrementAndGet();
        this.log.info("{} - counter set to {}", (Object)this, (Object)this.counter.get());
    }
}

