/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tenant.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.tenant.Tenant;
import org.apache.sling.tenant.internal.TenantProviderImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TenantAdapterFactory
implements AdapterFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    static final Class<ResourceResolver> RESOURCERESOLVER_CLASS = ResourceResolver.class;
    private static final Class<Resource> RESOURCE_CLASS = Resource.class;
    private static final Class<Tenant> TENANT_CLASS = Tenant.class;
    private final TenantProviderImpl tenantProvider;
    private final ServiceRegistration<?> service;
    private final List<Pattern> pathPatterns;

    TenantAdapterFactory(BundleContext bundleContext, TenantProviderImpl tenantProvider, String[] pathMatchers) {
        this.tenantProvider = tenantProvider;
        this.pathPatterns = new ArrayList<Pattern>();
        for (String matcherStr : pathMatchers) {
            this.pathPatterns.add(Pattern.compile(matcherStr));
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.description", "Apache Sling Tenant Adapter");
        ((Dictionary)props).put("adapters", new String[]{TENANT_CLASS.getName()});
        ((Dictionary)props).put("adaptables", new String[]{RESOURCERESOLVER_CLASS.getName(), RESOURCE_CLASS.getName()});
        this.service = bundleContext.registerService("org.apache.sling.api.adapter.AdapterFactory", (Object)this, props);
    }

    void dispose() {
        if (this.service != null) {
            this.service.unregister();
        }
    }

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((Session)((ResourceResolver)adaptable).adaptTo(Session.class), type);
        }
        if (adaptable instanceof Resource) {
            return this.getAdapter(((Resource)adaptable).getPath(), type);
        }
        this.log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Session session, Class<AdapterType> type) {
        if (session instanceof JackrabbitSession) {
            String userID = session.getUserID();
            JackrabbitSession jrSession = (JackrabbitSession)session;
            try {
                Authorizable authorizable = jrSession.getUserManager().getAuthorizable(userID);
                String userHome = authorizable.getPath();
                return this.getAdapter(userHome, type);
            }
            catch (Exception e) {
                this.log.error("can not get user from session", (Throwable)e);
            }
        }
        this.log.debug("Unable to adapt to resource of type {}", (Object)type.getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(String path, Class<AdapterType> type) {
        if (type == TENANT_CLASS) {
            return (AdapterType)this.resolveTenantByPath(path);
        }
        this.log.debug("Unable to adapt to resource of type {}", (Object)type.getName());
        return null;
    }

    private Tenant resolveTenantByPath(String path) {
        for (Pattern pathPattern : this.pathPatterns) {
            String tenantId;
            Tenant tenant;
            Matcher matcher = pathPattern.matcher(path);
            if (!matcher.find() || matcher.groupCount() < 1 || (tenant = this.tenantProvider.getTenant(tenantId = matcher.group(1))) == null) continue;
            return tenant;
        }
        this.log.debug("Cannot resolve {} to a Tenant", (Object)path);
        return null;
    }
}

