/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.xss.ProtectionContext;
import org.apache.sling.xss.XSSFilter;
import org.apache.sling.xss.impl.HtmlToHtmlContentContext;
import org.apache.sling.xss.impl.PlainTextToHtmlContentContext;
import org.apache.sling.xss.impl.PolicyHandler;
import org.apache.sling.xss.impl.XSSFilterRule;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={EventHandler.class, XSSFilter.class})
@Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/*"})
public class XSSFilterImpl
implements XSSFilter,
EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSSFilterImpl.class);
    private static final String DEFAULT_POLICY_PATH = "sling/xss/config.xml";
    private static final int DEFAULT_POLICY_CACHE_SIZE = 128;
    private PolicyHandler defaultHandler;
    private final XSSFilterRule htmlHtmlContext = new HtmlToHtmlContentContext();
    private final XSSFilterRule plainHtmlContext = new PlainTextToHtmlContentContext();
    private Map<String, PolicyHandler> policies = new ConcurrentHashMap<String, PolicyHandler>();
    @Reference
    private ResourceResolverFactory resourceResolverFactory = null;

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        if (path.endsWith("/sling/xss/config.xml")) {
            this.updateDefaultHandler();
        }
    }

    @Override
    public boolean check(ProtectionContext context, String src) {
        return this.check(context, src, null);
    }

    @Override
    public String filter(String src) {
        return this.filter(XSSFilter.DEFAULT_CONTEXT, src);
    }

    @Override
    public String filter(ProtectionContext context, String src) {
        return this.filter(context, src, null);
    }

    @Activate
    protected void activate() {
        this.updateDefaultHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDefaultHandler() {
        ResourceResolver adminResolver = null;
        try {
            InputStream policyStream;
            adminResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource policyResource = adminResolver.getResource(DEFAULT_POLICY_PATH);
            if (policyResource != null && (policyStream = (InputStream)policyResource.adaptTo(InputStream.class)) != null) {
                try {
                    if (this.defaultHandler == null) {
                        this.defaultHandler = new PolicyHandler(policyStream);
                        policyStream.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unable to load policy from " + policyResource.getPath(), (Throwable)e);
                }
            }
            if (this.defaultHandler == null) {
                throw new IllegalStateException("Cannot load a default policy handler.");
            }
        }
        catch (LoginException e) {
            LOGGER.error("Unable to load the default policy file.", (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    private XSSFilterRule getFilterRule(ProtectionContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (context == ProtectionContext.HTML_HTML_CONTENT) {
            return this.htmlHtmlContext;
        }
        return this.plainHtmlContext;
    }

    public boolean check(ProtectionContext context, String src, String policy) {
        XSSFilterRule ctx = this.getFilterRule(context);
        PolicyHandler handler = null;
        if (ctx.supportsPolicy() && (policy == null || (handler = this.policies.get(policy)) == null)) {
            handler = this.defaultHandler;
        }
        return ctx.check(handler, src);
    }

    public String filter(ProtectionContext context, String src, String policy) {
        if (src == null) {
            return "";
        }
        XSSFilterRule ctx = this.getFilterRule(context);
        PolicyHandler handler = null;
        if (ctx.supportsPolicy() && (policy == null || (handler = this.policies.get(policy)) == null)) {
            handler = this.defaultHandler;
        }
        return ctx.filter(handler, src);
    }

    public void setDefaultPolicy(InputStream policyStream) throws Exception {
        this.defaultHandler = new PolicyHandler(policyStream);
    }

    public void resetDefaultPolicy() {
        this.updateDefaultHandler();
    }

    public void loadPolicy(String policyName, InputStream policyStream) throws Exception {
        if (this.policies.size() < 128) {
            PolicyHandler policyHandler = new PolicyHandler(policyStream);
            this.policies.put(policyName, policyHandler);
        }
    }

    public void unloadPolicy(String policyName) {
        this.policies.remove(policyName);
    }

    public boolean hasPolicy(String policyName) {
        return this.policies.containsKey(policyName);
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

