/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.slf4j;

import java.util.HashMap;
import java.util.Map;
import org.owasp.esapi.Logger;
import org.owasp.esapi.logging.cleaning.LogScrubber;
import org.owasp.esapi.logging.slf4j.Slf4JLogBridge;
import org.owasp.esapi.logging.slf4j.Slf4JLogLevelHandler;
import org.slf4j.IMarkerFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;

public class Slf4JLogBridgeImpl
implements Slf4JLogBridge {
    private static final IMarkerFactory MARKER_FACTORY = new BasicMarkerFactory();
    private final Map<Integer, Slf4JLogLevelHandler> esapiSlfLevelMap;
    private final LogScrubber scrubber;

    public Slf4JLogBridgeImpl(LogScrubber logScrubber, Map<Integer, Slf4JLogLevelHandler> esapiSlfHandlerMap) {
        this.esapiSlfLevelMap = new HashMap<Integer, Slf4JLogLevelHandler>(esapiSlfHandlerMap);
        this.scrubber = logScrubber;
    }

    @Override
    public void log(Logger logger, int esapiLevel, Logger.EventType type, String message) {
        Slf4JLogLevelHandler handler = this.esapiSlfLevelMap.get(esapiLevel);
        if (handler == null) {
            throw new IllegalArgumentException("Unable to lookup SLF4J level mapping for esapi value of " + esapiLevel);
        }
        if (handler.isEnabled(logger)) {
            Marker typeMarker = MARKER_FACTORY.getMarker(type.toString());
            String cleanString = this.scrubber.cleanMessage(message);
            handler.log(logger, typeMarker, cleanString);
        }
    }

    @Override
    public void log(Logger logger, int esapiLevel, Logger.EventType type, String message, Throwable throwable) {
        Slf4JLogLevelHandler handler = this.esapiSlfLevelMap.get(esapiLevel);
        if (handler == null) {
            throw new IllegalArgumentException("Unable to lookup SLF4J level mapping for esapi value of " + esapiLevel);
        }
        if (handler.isEnabled(logger)) {
            Marker typeMarker = MARKER_FACTORY.getMarker(type.toString());
            String cleanString = this.scrubber.cleanMessage(message);
            handler.log(logger, typeMarker, cleanString, throwable);
        }
    }
}

