/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.xml;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.sling.xss.impl.xml.AllowedEmptyTags;
import org.apache.sling.xss.impl.xml.Attribute;
import org.apache.sling.xss.impl.xml.Directive;
import org.apache.sling.xss.impl.xml.DynamicTagAttributes;
import org.apache.sling.xss.impl.xml.GlobalTagAttributes;
import org.apache.sling.xss.impl.xml.Property;
import org.apache.sling.xss.impl.xml.Regexp;
import org.apache.sling.xss.impl.xml.Tag;
import org.apache.sling.xss.impl.xml.TagsToEncode;

@JacksonXmlRootElement(localName="anti-samy-rules")
public class AntiSamyRules {
    @JsonIgnore
    @JacksonXmlProperty(localName="xmlns:xsi", isAttribute=true)
    private String xmlnsXsi;
    @JsonIgnore
    @JacksonXmlProperty(localName="noNamespaceSchemaLocation", isAttribute=true)
    private String noNamespaceSchemaLocation;
    @JacksonXmlElementWrapper(localName="directives")
    @JacksonXmlProperty(localName="directive")
    private List<Directive> directiveList = Collections.emptyList();
    @JacksonXmlElementWrapper(localName="common-regexps")
    @JacksonXmlProperty(localName="regexp")
    private List<Regexp> regexpList = Collections.emptyList();
    @JacksonXmlElementWrapper(localName="common-attributes")
    @JacksonXmlProperty(localName="attribute")
    private List<Attribute> commonAttributeList = Collections.emptyList();
    @JacksonXmlProperty(localName="global-tag-attributes")
    private GlobalTagAttributes globalTagAttributes;
    @JacksonXmlProperty(localName="dynamic-tag-attributes")
    private DynamicTagAttributes dynamicTagAttribute;
    @JacksonXmlElementWrapper(localName="tag-rules")
    @JacksonXmlProperty(localName="tag")
    private List<Tag> tagRulesList = Collections.emptyList();
    @JacksonXmlProperty(localName="tags-to-encode")
    private TagsToEncode tagsToEncode;
    @JacksonXmlElementWrapper(localName="css-rules")
    @JacksonXmlProperty(localName="property")
    private List<Property> propertyList = Collections.emptyList();
    @JacksonXmlProperty(localName="allowed-empty-tags")
    private AllowedEmptyTags allowedEmptyTags;

    public AllowedEmptyTags getAllowedEmptyTags() {
        return this.allowedEmptyTags;
    }

    public DynamicTagAttributes getDynamicTagAttribute() {
        return this.dynamicTagAttribute;
    }

    public GlobalTagAttributes getGlobalTagAttributes() {
        return this.globalTagAttributes;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public TagsToEncode getTagsToEncode() {
        return this.tagsToEncode;
    }

    public String getXmlnsXsi() {
        return this.xmlnsXsi;
    }

    public List<Attribute> getCommonAttributeList() {
        return this.commonAttributeList;
    }

    public List<Directive> getDirectiveList() {
        return this.directiveList;
    }

    public List<Regexp> getRegexpList() {
        return this.regexpList;
    }

    public List<Property> getPropertyList() {
        return this.propertyList;
    }

    public List<Tag> getTagRulesList() {
        return this.tagRulesList;
    }

    public Map<String, String> getDirectivesByName() {
        return this.directiveList.stream().collect(Collectors.toMap(Directive::getName, Directive::getValue));
    }

    public Map<String, Pattern> getCommonPatternByName() {
        return this.regexpList.stream().collect(Collectors.toMap(Regexp::getName, Regexp::getPattern));
    }
}

