/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.xml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.sling.xss.impl.xml.Literal;
import org.apache.sling.xss.impl.xml.Regexp;
import org.jetbrains.annotations.NotNull;

public class Attribute {
    @NotNull
    private final String name;
    private final String description;
    private final String onInvalid;
    private final List<Regexp> regexpList;
    private final List<Literal> literalList;

    @JsonCreator
    public Attribute(@JacksonXmlProperty(localName="name", isAttribute=true) @NotNull String name, @JacksonXmlProperty(localName="regexp-list") List<Regexp> allowedRegexps, @JacksonXmlProperty(localName="literal-list") List<Literal> literalList, @JacksonXmlProperty(localName="onInvalid", isAttribute=true) String onInvalid, @JacksonXmlProperty(localName="description", isAttribute=true) String description) {
        this.name = name;
        this.description = Optional.ofNullable(description).orElse("");
        this.onInvalid = onInvalid != null && onInvalid.length() > 0 ? onInvalid : "removeAttribute";
        this.regexpList = Optional.ofNullable(allowedRegexps).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
        this.literalList = Optional.ofNullable(literalList).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
    }

    public String toString() {
        return "Attribute - name: " + this.name + ", description " + this.description + ", onInvalid " + this.onInvalid + ", allowedRegexlist: " + this.regexpList.size() + ", literals " + this.literalList;
    }

    @NotNull
    public String getOnInvalid() {
        return this.onInvalid;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getLiterals() {
        return this.getLiteralList().stream().map(Literal::getValue).map(String::toLowerCase).collect(Collectors.toList());
    }

    @NotNull
    public List<Literal> getLiteralList() {
        return this.literalList;
    }

    @NotNull
    public List<Pattern> getPatternList() {
        return this.getRegexpList().stream().map(Regexp::getPattern).collect(Collectors.toList());
    }

    @NotNull
    public List<Regexp> getRegexpList() {
        return this.regexpList;
    }

    public boolean containsAllowedValue(String valueInLowerCase) {
        return this.getLiteralList().stream().map(Literal::getValue).anyMatch(valueInLowerCase::equals);
    }

    public boolean matchesAllowedExpression(String value) {
        return this.getPatternList().stream().anyMatch(pattern -> pattern.matcher(value).matches());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Attribute) {
            Attribute attribute = (Attribute)obj;
            return this.name == attribute.name || attribute.name.equals(this.name) && this.description == attribute.description || attribute.description.equals(this.description) && this.onInvalid == attribute.onInvalid || attribute.onInvalid.equals(this.onInvalid) && this.regexpList == attribute.regexpList || attribute.regexpList.equals(this.regexpList) && this.literalList == attribute.literalList;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + this.description.hashCode() + this.onInvalid.hashCode();
    }
}

