/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.slf4j;

import java.util.ArrayList;
import java.util.HashMap;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.LogFactory;
import org.owasp.esapi.Logger;
import org.owasp.esapi.codecs.HTMLEntityCodec;
import org.owasp.esapi.logging.appender.LogAppender;
import org.owasp.esapi.logging.appender.LogPrefixAppender;
import org.owasp.esapi.logging.cleaning.CodecLogScrubber;
import org.owasp.esapi.logging.cleaning.CompositeLogScrubber;
import org.owasp.esapi.logging.cleaning.LogScrubber;
import org.owasp.esapi.logging.cleaning.NewlineLogScrubber;
import org.owasp.esapi.logging.slf4j.Slf4JLogBridge;
import org.owasp.esapi.logging.slf4j.Slf4JLogBridgeImpl;
import org.owasp.esapi.logging.slf4j.Slf4JLogLevelHandler;
import org.owasp.esapi.logging.slf4j.Slf4JLogLevelHandlers;
import org.owasp.esapi.logging.slf4j.Slf4JLogger;
import org.slf4j.LoggerFactory;

public class Slf4JLogFactory
implements LogFactory {
    private static final char BACKSLASH = '\\';
    private static final char OPEN_SLF_FORMAT = '{';
    private static final char CLOSE_SLF_FORMAT = '}';
    private static final char[] IMMUNE_SLF4J_HTML = new char[]{',', '.', '-', '_', ' ', '\\', '{', '}'};
    private static final HTMLEntityCodec HTML_CODEC = new HTMLEntityCodec();
    private static LogAppender SLF4J_LOG_APPENDER;
    private static LogScrubber SLF4J_LOG_SCRUBBER;
    private static Slf4JLogBridge LOG_BRIDGE;

    static LogScrubber createLogScrubber(boolean requiresEncoding) {
        ArrayList<LogScrubber> messageScrubber = new ArrayList<LogScrubber>();
        messageScrubber.add(new NewlineLogScrubber());
        if (requiresEncoding) {
            messageScrubber.add(new CodecLogScrubber(HTML_CODEC, IMMUNE_SLF4J_HTML));
        }
        return new CompositeLogScrubber(messageScrubber);
    }

    static LogAppender createLogAppender(boolean logUserInfo, boolean logClientInfo, boolean logServerIp, boolean logApplicationName, String appName) {
        return new LogPrefixAppender(logUserInfo, logClientInfo, logServerIp, logApplicationName, appName);
    }

    @Override
    public Logger getLogger(String moduleName) {
        org.slf4j.Logger slf4JLogger = LoggerFactory.getLogger((String)moduleName);
        return new Slf4JLogger(slf4JLogger, LOG_BRIDGE, Integer.MIN_VALUE);
    }

    @Override
    public Logger getLogger(Class clazz) {
        org.slf4j.Logger slf4JLogger = LoggerFactory.getLogger((Class)clazz);
        return new Slf4JLogger(slf4JLogger, LOG_BRIDGE, Integer.MIN_VALUE);
    }

    static {
        boolean encodeLog = ESAPI.securityConfiguration().getBooleanProp("Logger.LogEncodingRequired");
        SLF4J_LOG_SCRUBBER = Slf4JLogFactory.createLogScrubber(encodeLog);
        boolean logUserInfo = ESAPI.securityConfiguration().getBooleanProp("Logger.UserInfo");
        boolean logClientInfo = ESAPI.securityConfiguration().getBooleanProp("Logger.ClientInfo");
        boolean logApplicationName = ESAPI.securityConfiguration().getBooleanProp("Logger.LogApplicationName");
        String appName = ESAPI.securityConfiguration().getStringProp("Logger.ApplicationName");
        boolean logServerIp = ESAPI.securityConfiguration().getBooleanProp("Logger.LogServerIP");
        SLF4J_LOG_APPENDER = Slf4JLogFactory.createLogAppender(logUserInfo, logClientInfo, logServerIp, logApplicationName, appName);
        HashMap<Integer, Slf4JLogLevelHandler> levelLookup = new HashMap<Integer, Slf4JLogLevelHandler>();
        levelLookup.put(Integer.MIN_VALUE, Slf4JLogLevelHandlers.TRACE);
        levelLookup.put(100, Slf4JLogLevelHandlers.TRACE);
        levelLookup.put(200, Slf4JLogLevelHandlers.DEBUG);
        levelLookup.put(400, Slf4JLogLevelHandlers.INFO);
        levelLookup.put(800, Slf4JLogLevelHandlers.ERROR);
        levelLookup.put(600, Slf4JLogLevelHandlers.WARN);
        levelLookup.put(1000, Slf4JLogLevelHandlers.ERROR);
        LOG_BRIDGE = new Slf4JLogBridgeImpl(SLF4J_LOG_APPENDER, SLF4J_LOG_SCRUBBER, levelLookup);
    }
}

