/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.status;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sling.xss.impl.status.FixedSizeMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={XSSStatusService.class})
@Designate(ocd=Configuration.class)
public class XSSStatusService {
    public static final int MAX_INVALID_URLS_RECORDED = 1000;
    private Map<String, AtomicInteger> invalidUrls = new HashMap<String, AtomicInteger>();

    public void reportInvalidUrl(@NotNull String url) {
        if (this.invalidUrls.containsKey(url)) {
            this.invalidUrls.get(url).incrementAndGet();
        } else {
            this.invalidUrls.put(url, new AtomicInteger(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AtomicInteger> getInvalidUrls() {
        Map<String, AtomicInteger> map = this.invalidUrls;
        synchronized (map) {
            return XSSStatusService.sortByNumericValue(this.invalidUrls);
        }
    }

    @Activate
    private void activate(Configuration configuration) {
        this.invalidUrls = Collections.synchronizedMap(new FixedSizeMap(configuration.maxNumberOfInvalidUrlsRecorded()));
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByComparableValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        list.sort(Map.Entry.comparingByValue());
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static <K, V extends Number> Map<K, V> sortByNumericValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        list.sort((left, right) -> {
            double rightNumber;
            double leftNumber = ((Number)left.getValue()).doubleValue();
            if (leftNumber < (rightNumber = ((Number)right.getValue()).doubleValue())) {
                return -1;
            }
            if (leftNumber > rightNumber) {
                return 1;
            }
            return 0;
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @ObjectClassDefinition(name="Apache Sling XSS Status Service", description="The XSS Protection API Status Service provides various statistics about how the library was used.")
    static @interface Configuration {
        @AttributeDefinition(name="Maximum number of recorded invalid URLs", description="Once this number is reached, previously recorded invalid URLs will be discarded.")
        public int maxNumberOfInvalidUrlsRecorded() default 1000;
    }
}

