/*
 * Decompiled with CFR 0.152.
 */
package slingxss.com.google.common.collect;

import java.util.Queue;
import javax.annotation.CheckForNull;
import slingxss.com.google.common.annotations.GwtCompatible;
import slingxss.com.google.common.base.Preconditions;
import slingxss.com.google.common.collect.AbstractIterator;
import slingxss.com.google.common.collect.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

