/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;

public class MemoryLogHandler
implements LogHandler {
    final List<LogRecord> records = new ArrayList<LogRecord>();
    private final Boolean outputToConsole;
    private final File sourceDirectory;
    private final Consumer<LogRecord> recordConsumer;

    public MemoryLogHandler(Boolean outputToConsole, File sourceDirectory, Consumer<LogRecord> recordConsumer) {
        this.outputToConsole = outputToConsole == null ? Boolean.FALSE : outputToConsole;
        this.sourceDirectory = sourceDirectory;
        this.recordConsumer = recordConsumer;
    }

    public void log(LogRecord logRecord) {
        this.records.add(logRecord);
        if (this.outputToConsole.booleanValue()) {
            this.recordConsumer.accept(logRecord);
        }
    }

    public void clear() {
        this.records.clear();
    }

    public List<LogRecord> filter(Severity severity) {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        for (LogRecord record : this.records) {
            if (record.getSeverity().ordinal() < severity.ordinal()) continue;
            records.add(record);
        }
        return records;
    }

    public List<LogRecord> filter(String text) {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        for (LogRecord record : this.records) {
            if (!record.getMessage().contains(text)) continue;
            records.add(record);
        }
        return records;
    }

    public List<LogRecord> filter(Severity severity, String text) {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        for (LogRecord record : this.records) {
            if (record.getSeverity().ordinal() < severity.ordinal() || !record.getMessage().contains(text)) continue;
            records.add(record);
        }
        return records;
    }
}

