/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import org.asciidoctor.ast.ContentNode;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;

public class NodeCache {
    private static final String ASCIIDOCTORJ_CACHE = "asciidoctorj_cache";
    private static final String KEY_AST_NODE = "asciidoctorj_node";
    private final RubyHash cache;
    private Ruby runtime;

    public static NodeCache get(IRubyObject rubyObject) {
        RubyHash cache = (RubyHash)rubyObject.getInstanceVariables().getInstanceVariable(ASCIIDOCTORJ_CACHE);
        if (cache == null) {
            cache = RubyHash.newHash((Ruby)rubyObject.getRuntime());
            rubyObject.getInstanceVariables().setInstanceVariable(ASCIIDOCTORJ_CACHE, (IRubyObject)cache);
        }
        return new NodeCache(cache);
    }

    private NodeCache(RubyHash cache) {
        this.cache = cache;
        this.runtime = cache.getRuntime();
    }

    public ContentNode getASTNode() {
        ContentNode astNode = (ContentNode)this.cache.get((Object)this.getRuntime().newSymbol(KEY_AST_NODE));
        return astNode;
    }

    public void setASTNode(ContentNode astNode) {
        this.cache.put((Object)this.getRuntime().newSymbol(KEY_AST_NODE), (Object)astNode);
    }

    Ruby getRuntime() {
        return this.cache.getRuntime();
    }
}

