/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.inject;

import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.atmosphere.inject.InjectIntrospectorAdapter;
import org.atmosphere.inject.annotation.ApplicationScoped;
import org.atmosphere.inject.annotation.RequestScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@RequestScoped
public class PostConstructIntrospector
extends InjectIntrospectorAdapter<PostConstruct> {
    private final Logger logger = LoggerFactory.getLogger(PostConstructIntrospector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void introspectMethod(Method m, Object instance) {
        if (!m.isAnnotationPresent(PostConstruct.class)) {
            return;
        }
        try {
            m.setAccessible(true);
            m.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        finally {
            m.setAccessible(false);
        }
    }
}

