/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import jakarta.servlet.http.HttpSession;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.Deliver;

public class ExcludeSessionBroadcaster
extends DefaultBroadcaster {
    @Override
    public Broadcaster initialize(String id, AtmosphereConfig config) {
        return super.initialize(id, config);
    }

    @Override
    public Future<Object> broadcast(Object msg, AtmosphereResource r) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        HashSet<AtmosphereResource> sub = new HashSet<AtmosphereResource>(this.resources);
        sub.remove(r);
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg, sub.size());
        this.dispatchMessages(new Deliver(newMsg, sub, f, msg));
        return f;
    }

    @Override
    public Future<Object> broadcast(Object msg, Set<AtmosphereResource> subset) {
        if (this.destroyed.get()) {
            return this.futureDone(msg);
        }
        subset.retainAll(this.resources);
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return this.futureDone(msg);
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg, subset.size());
        this.dispatchMessages(new Deliver(newMsg, subset, f, msg));
        return f;
    }

    public Future<Object> broadcast(Object msg, List<HttpSession> sessions) {
        if (this.destroyed.get()) {
            return this.futureDone(msg);
        }
        HashSet<AtmosphereResource> subset = new HashSet<AtmosphereResource>(this.resources);
        for (AtmosphereResource r : this.resources) {
            if (r.getAtmosphereResourceEvent().isCancelled() || !sessions.contains(r.getRequest().getSession())) continue;
            subset.remove(r);
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return this.futureDone(msg);
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg, subset.size());
        this.dispatchMessages(new Deliver(newMsg, subset, f, msg));
        return f;
    }

    public Future<Object> broadcast(Object msg, HttpSession s) {
        if (this.destroyed.get()) {
            return this.futureDone(msg);
        }
        HashSet<AtmosphereResource> subset = new HashSet<AtmosphereResource>(this.resources);
        for (AtmosphereResource r : this.resources) {
            if (r.getAtmosphereResourceEvent().isCancelled() || !s.equals(r.getRequest().getSession())) continue;
            subset.remove(r);
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return this.futureDone(msg);
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg, subset.size());
        this.dispatchMessages(new Deliver(newMsg, subset, f, msg));
        return f;
    }
}

