/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.utils;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.model.JClass;
import org.ballerinalang.bindgen.model.JField;
import org.ballerinalang.bindgen.model.JMethod;
import org.ballerinalang.bindgen.model.JParameter;
import org.ballerinalang.bindgen.utils.ChildFirstClassLoader;

public class BindgenUtils {
    private static PrintStream errStream;
    private static PrintStream outStream;

    private BindgenUtils() {
    }

    public static void writeOutputFile(Object object, String templateDir, String templateName, String outPath, Boolean append) throws BindgenException {
        PrintWriter writer = null;
        FileWriterWithEncoding fileWriter = null;
        try {
            Template template = BindgenUtils.compileTemplate(templateDir, templateName);
            Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, new CustomFieldValueResolver()}).build();
            fileWriter = new FileWriterWithEncoding(outPath, StandardCharsets.UTF_8, append.booleanValue());
            writer = new PrintWriter((Writer)fileWriter);
            writer.println(template.apply(context));
            fileWriter.close();
        }
        catch (IOException e) {
            throw new BindgenException("Unable to create the Ballerina file: " + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Template compileTemplate(String defaultTemplateDir, String templateName) throws BindgenException {
        String templatesDirPath = System.getProperty("templates.dir.path", defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(".mustache");
        fileTemplateLoader.setSuffix(".mustache");
        Handlebars handlebars = new Handlebars().with(new TemplateLoader[]{cpTemplateLoader, fileTemplateLoader});
        handlebars.registerHelper("replace", (object, options) -> {
            if (object instanceof String) {
                return ((String)object).replace((CharSequence)options.param(0), (CharSequence)options.param(1));
            }
            return "";
        });
        handlebars.registerHelper("controlChars", (object, options) -> {
            if (object instanceof String) {
                return "'" + object;
            }
            return "";
        });
        handlebars.registerHelper("getSimpleName", (object, options) -> {
            if (object instanceof String) {
                String className = (String)object;
                return className.substring(className.lastIndexOf(46) + 1);
            }
            return object;
        });
        handlebars.registerHelper("getParams", (object, options) -> {
            String returnString = "";
            if (object instanceof JParameter) {
                JParameter param = (JParameter)object;
                returnString = BindgenUtils.getParamsHelper(param);
            }
            return returnString;
        });
        handlebars.registerHelper("getReturn", (object, options) -> {
            String returnString = "";
            if (object instanceof JMethod) {
                JMethod jMethod = (JMethod)object;
                returnString = BindgenUtils.getReturnHelper(jMethod);
            }
            return returnString;
        });
        handlebars.registerHelper("getInteropMethod", (object, options) -> {
            String returnString = "";
            if (object instanceof JMethod) {
                JMethod jMethod = (JMethod)object;
                String type = options.params[0].toString();
                if (type.equals("param")) {
                    returnString = BindgenUtils.getInteropMethodParam(jMethod);
                } else if (type.equals("return")) {
                    returnString = BindgenUtils.getInteropMethodReturn(jMethod);
                }
            }
            return returnString;
        });
        handlebars.registerHelper("getInteropFieldParam", (object, options) -> {
            String returnString = "";
            if (object instanceof JField) {
                JField jField = (JField)object;
                returnString = BindgenUtils.getInteropFieldParam(jField);
            }
            return returnString;
        });
        try {
            return handlebars.compile(templateName);
        }
        catch (FileNotFoundException e) {
            throw new BindgenException("Code generation template file does not exist: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BindgenException("Unable to read the " + templateName + " template file: " + e.getMessage(), e);
        }
    }

    private static String getInteropFieldParam(JField jField) {
        StringBuilder returnString = new StringBuilder();
        if (!jField.isStatic()) {
            returnString.append("handle receiver");
        }
        if (jField.isSetter()) {
            if (!jField.isStatic()) {
                returnString.append(", ");
            }
            returnString.append(jField.getExternalType()).append(" arg");
        }
        return returnString.toString();
    }

    private static String getInteropMethodReturn(JMethod jMethod) {
        StringBuilder returnString = new StringBuilder();
        if (jMethod.getHasReturn().booleanValue()) {
            returnString.append(" returns ").append(jMethod.getExternalType());
            if (jMethod.isHandleException()) {
                returnString.append("|error");
            }
        } else if (jMethod.isHandleException()) {
            returnString.append(" returns error?");
        }
        return returnString.toString();
    }

    private static String getInteropMethodParam(JMethod jMethod) {
        StringBuilder returnString = new StringBuilder();
        if (!jMethod.isStatic()) {
            returnString.append("handle receiver");
            if (jMethod.hasParams()) {
                returnString.append(", ");
            }
        }
        for (JParameter param : jMethod.getParameters()) {
            returnString.append(param.getExternalType()).append(" ").append(param.getFieldName());
            if (!param.getHasNext().booleanValue()) continue;
            returnString.append(", ");
        }
        return returnString.toString();
    }

    private static String getParamsHelper(JParameter param) {
        StringBuilder returnString = new StringBuilder();
        String checkToHandle = "check jarrays:toHandle(";
        if (param.getIsObjArray().booleanValue()) {
            returnString.append(checkToHandle).append(param.getFieldName()).append(", \"").append(param.getComponentType()).append("\")");
        } else if (param.getIsPrimitiveArray().booleanValue()) {
            returnString.append(checkToHandle).append(param.getFieldName()).append(", \"").append(param.getComponentType()).append("\")");
        } else if (param.getIsString().booleanValue()) {
            returnString.append("java:fromString(").append(param.getFieldName()).append(")");
        } else if (param.getIsStringArray().booleanValue()) {
            returnString.append(checkToHandle).append(param.getFieldName()).append(", \"java.lang.String\")");
        } else {
            returnString.append(param.getFieldName());
            if (param.getIsObj().booleanValue()) {
                returnString.append(".jObj");
            }
        }
        if (param.getHasNext().booleanValue()) {
            returnString.append(", ");
        }
        return returnString.toString();
    }

    private static String getReturnHelper(JMethod jMethod) {
        StringBuilder returnString = new StringBuilder();
        if (jMethod.getHasReturn().booleanValue()) {
            returnString.append("returns ");
            returnString.append(jMethod.getReturnType());
            if (jMethod.getIsStringReturn().booleanValue()) {
                returnString.append("?");
            }
            if (jMethod.getHasException().booleanValue()) {
                if (jMethod.isHandleException()) {
                    returnString.append("|").append(jMethod.getExceptionName());
                    if (jMethod.isReturnError()) {
                        returnString.append("|error");
                    }
                } else {
                    returnString.append("|error");
                }
            }
        } else if (jMethod.getHasException().booleanValue() || jMethod.getHasPrimitiveParam().booleanValue()) {
            returnString.append("returns error?");
        }
        return returnString.toString();
    }

    private static void listAllFiles(String directoryName, List<File> files) {
        File directory = new File(directoryName);
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isFile()) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                BindgenUtils.listAllFiles(file.getAbsolutePath(), files);
            }
        }
    }

    public static void notifyExistingDependencies(Set<String> classList, File dependencyPath) {
        if (dependencyPath.isDirectory()) {
            ArrayList<File> listOfFiles = new ArrayList<File>();
            BindgenUtils.listAllFiles(dependencyPath.toString(), listOfFiles);
            if (listOfFiles.size() > 1) {
                for (String className : classList) {
                    for (File file : listOfFiles) {
                        String fileName = BindingsGenerator.aliases.get(className);
                        if (!file.getName().equals(fileName + ".bal")) continue;
                        try {
                            Files.delete(file.toPath());
                            outStream.println("\nSuccessfully deleted the existing dependency: " + file.getPath());
                        }
                        catch (IOException e) {
                            errStream.println("\nFailed to delete the existing dependency: " + e.getMessage());
                        }
                    }
                }
            }
        }
    }

    public static List<String> getExistingBindings(Set<String> classList, File bindingsPath) {
        ArrayList<String> removeList = new ArrayList<String>();
        if (bindingsPath.isDirectory()) {
            ArrayList<File> listOfFiles = new ArrayList<File>();
            BindgenUtils.listAllFiles(bindingsPath.toString(), listOfFiles);
            if (listOfFiles.size() > 1) {
                block0: for (String className : classList) {
                    for (File file : listOfFiles) {
                        String fileName = BindingsGenerator.aliases.get(className);
                        if (!file.getName().equals(fileName + ".bal") || !file.getParentFile().getName().equals(className.substring(0, className.lastIndexOf(46)))) continue;
                        removeList.add(className);
                        continue block0;
                    }
                }
            }
        }
        return removeList;
    }

    public static Set<String> getUpdatedConstantsList(Path existingPath, Set<String> classList) {
        try {
            List<String> allLines = Files.readAllLines(Paths.get(existingPath.toString(), new String[0]));
            ArrayList<String> removeList = new ArrayList<String>();
            block2: for (String className : classList) {
                for (String line : allLines) {
                    if (!line.contains("\"" + className + "\"")) continue;
                    removeList.add(className);
                    continue block2;
                }
            }
            classList.removeAll(removeList);
        }
        catch (IOException | ConcurrentModificationException e) {
            errStream.println("\nError while reading the existing constants file: " + e);
        }
        return classList;
    }

    public static void createDirectory(String path) throws BindgenException {
        File directory = new File(path);
        if (!directory.exists()) {
            try {
                boolean mkdirResult = directory.mkdirs();
                if (!mkdirResult) {
                    throw new BindgenException("Unable to create the directory: " + path);
                }
            }
            catch (SecurityException e) {
                throw new BindgenException("Unable to create the directory: " + path, e);
            }
        }
    }

    public static boolean isPublicField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isPublicMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isPublicClass(Class javaClass) {
        int modifiers = javaClass.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isStaticField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public static boolean isStaticMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public static boolean isFinalField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers);
    }

    public static boolean isAbstractClass(Class javaClass) {
        int modifiers = javaClass.getModifiers();
        return Modifier.isAbstract(modifiers) && !javaClass.isInterface();
    }

    public static void handleOverloadedMethods(List<JMethod> methodList, List<JMethod> methods, JClass jClass) {
        for (JMethod method : methods) {
            jClass.setMethodCount(method.getMethodName());
            if (jClass.getMethodCount(method.getMethodName()) <= 1) continue;
            for (JMethod jMethod : methodList) {
                if (!jMethod.getMethod().equals(method.getMethod())) continue;
                jMethod.setMethodName(jMethod.getJavaMethodName() + jClass.getMethodCount(method.getMethodName()));
            }
        }
    }

    public static String getBallerinaParamType(Class javaType) {
        if (javaType.isArray() && javaType.getComponentType().isPrimitive()) {
            return BindgenUtils.getPrimitiveArrayBalType(javaType.getComponentType().getSimpleName());
        }
        String returnType = BindgenUtils.getBalType(BindgenUtils.getAlias(javaType));
        if (returnType.equals("handle")) {
            return BindgenUtils.getAlias(javaType);
        }
        return returnType;
    }

    public static String getBallerinaHandleType(Class javaType) {
        String type = javaType.getSimpleName();
        String returnType = BindgenUtils.getBalType(type);
        if (type.equals("String") || type.equals("String[]")) {
            returnType = "handle";
        }
        return returnType;
    }

    public static String getJavaType(Class javaType) {
        if (javaType.isArray()) {
            javaType = javaType.getComponentType();
        }
        if (javaType.isPrimitive()) {
            return javaType.getSimpleName();
        }
        if (javaType.getSimpleName().equals("String")) {
            return "string";
        }
        return "handle";
    }

    private static String getBalType(String type) {
        switch (type) {
            case "int": {
                return "int";
            }
            case "float": {
                return "float";
            }
            case "boolean": {
                return "boolean";
            }
            case "byte": {
                return "byte";
            }
            case "short": {
                return "int";
            }
            case "char": {
                return "int";
            }
            case "double": {
                return "float";
            }
            case "long": {
                return "int";
            }
            case "String": {
                return "string";
            }
            case "String[]": {
                return "string[]";
            }
        }
        return "handle";
    }

    private static String getPrimitiveArrayBalType(String type) {
        switch (type) {
            case "int": {
                return "int[]";
            }
            case "float": {
                return "float[]";
            }
            case "boolean": {
                return "boolean[]";
            }
            case "byte": {
                return "byte[]";
            }
            case "short": {
                return "int[]";
            }
            case "char": {
                return "int[]";
            }
            case "double": {
                return "float[]";
            }
            case "long": {
                return "int[]";
            }
        }
        return "handle";
    }

    public static String getPrimitiveArrayType(String type) {
        switch (type) {
            case "[C": 
            case "[S": 
            case "[J": {
                return "int[]";
            }
            case "[D": {
                return "float[]";
            }
            case "[B": {
                return "byte[]";
            }
            case "[I": {
                return "int[]";
            }
            case "[F": {
                return "float[]";
            }
            case "[Z": {
                return "boolean[]";
            }
        }
        return type;
    }

    public static URLClassLoader getClassLoader(Set<String> jarPaths, ClassLoader parent) throws BindgenException {
        URLClassLoader classLoader;
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            ArrayList<String> classPaths = new ArrayList<String>();
            ArrayList<String> failedClassPaths = new ArrayList<String>();
            for (String path : jarPaths) {
                File file = FileSystems.getDefault().getPath(path, new String[0]).toFile();
                if (file.isDirectory()) {
                    File[] paths = file.listFiles();
                    if (paths != null) {
                        for (File filePath : paths) {
                            if (!BindgenUtils.isJarFile(filePath)) continue;
                            urls.add(filePath.toURI().toURL());
                            classPaths.add(filePath.getName());
                        }
                        continue;
                    }
                    failedClassPaths.add(path);
                    continue;
                }
                if (BindgenUtils.isJarFile(file)) {
                    urls.add(file.toURI().toURL());
                    classPaths.add(file.getName());
                    continue;
                }
                failedClassPaths.add(file.toString());
            }
            if (!classPaths.isEmpty()) {
                outStream.println("\nFollowing jars were added to the classpath:");
                for (String path : classPaths) {
                    outStream.println("\t" + path);
                }
            }
            if (!failedClassPaths.isEmpty()) {
                errStream.println("\nFailed to add the following to classpath:");
                for (String path : failedClassPaths) {
                    outStream.println("\t" + path);
                }
            }
            classLoader = (URLClassLoader)AccessController.doPrivileged(() -> new ChildFirstClassLoader(urls.toArray(new URL[0]), parent));
        }
        catch (RuntimeException e) {
            throw new BindgenException("Error while loading the classpaths.", e);
        }
        catch (Exception e) {
            throw new BindgenException("Error while processing the classpaths.", e);
        }
        return classLoader;
    }

    private static boolean isJarFile(File file) {
        String fileName = file.getName();
        return file.isFile() && fileName.substring(fileName.lastIndexOf(46)).equals(".jar");
    }

    public static void setErrStream(PrintStream errStream) {
        BindgenUtils.errStream = errStream;
    }

    public static void setOutStream(PrintStream outStream) {
        BindgenUtils.outStream = outStream;
    }

    public static String getAlias(Class className) {
        if (!BindingsGenerator.aliases.containsKey(className.getName())) {
            int i = 2;
            boolean notAdded = true;
            String simpleName = className.getSimpleName();
            String alias = simpleName;
            if (!BindingsGenerator.aliases.containsValue(alias)) {
                BindingsGenerator.aliases.put(className.getName(), alias);
            } else {
                while (notAdded) {
                    if (className.isArray()) {
                        int insertInto = simpleName.toCharArray().length - 2;
                        alias = simpleName.substring(0, insertInto) + i + simpleName.substring(insertInto);
                    } else {
                        alias = simpleName + i;
                    }
                    if (!BindingsGenerator.aliases.containsValue(alias)) {
                        BindingsGenerator.aliases.put(className.getName(), alias);
                        notAdded = false;
                    }
                    ++i;
                }
            }
        }
        return BindingsGenerator.aliases.get(className.getName());
    }

    static class CustomFieldValueResolver
    extends FieldValueResolver {
        CustomFieldValueResolver() {
        }

        protected Set<FieldValueResolver.FieldWrapper> members(Class<?> clazz) {
            Set members = super.members(clazz);
            return members.stream().filter(fw -> this.isValidField((FieldValueResolver.FieldWrapper)fw)).collect(Collectors.toSet());
        }

        boolean isValidField(FieldValueResolver.FieldWrapper fw) {
            if (fw instanceof AccessibleObject) {
                return this.isUseSetAccessible((Member)fw);
            }
            return true;
        }
    }
}

