/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.filepath.nativeimpl;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.regex.PatternSyntaxException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.filepath.Utils;

@BallerinaFunction(orgName="ballerina", packageName="filepath", functionName="matches", isPublic=true)
public class Matches
extends BlockingNativeCallableUnit {
    private static final String GLOB_SYNTAX_FLAVOR = "glob:";

    public void execute(Context context) {
        PathMatcher matcher;
        String inputPath = context.getStringArgument(0);
        String pattern = context.getStringArgument(1);
        FileSystem fs = FileSystems.getDefault();
        try {
            matcher = !pattern.startsWith(GLOB_SYNTAX_FLAVOR) ? fs.getPathMatcher(GLOB_SYNTAX_FLAVOR + pattern) : fs.getPathMatcher(pattern);
        }
        catch (PatternSyntaxException ex) {
            context.setReturnValues(new BValue[]{Utils.getPathError("INVALID_PATTERN", ex)});
            return;
        }
        if (inputPath == null) {
            context.setReturnValues(new BValue[]{new BBoolean(Boolean.FALSE.booleanValue())});
            return;
        }
        context.setReturnValues(new BValue[]{new BBoolean(matcher.matches(Paths.get(inputPath, new String[0])))});
    }
}

