/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.filepath.nativeimpl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.filepath.Utils;

@BallerinaFunction(orgName="ballerina", packageName="filepath", functionName="resolve", isPublic=true)
public class Resolve
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        String inputPath = context.getStringArgument(0);
        try {
            Path realPath = Files.readSymbolicLink(Paths.get(inputPath, new String[0]));
            context.setReturnValues(new BValue[]{new BString(realPath.toString())});
        }
        catch (NotLinkException ex) {
            context.setReturnValues(new BValue[]{Utils.getPathError("NOT_LINK_ERROR", ex)});
        }
        catch (IOException ex) {
            context.setReturnValues(new BValue[]{Utils.getPathError("IO_ERROR", ex)});
        }
        catch (SecurityException ex) {
            context.setReturnValues(new BValue[]{Utils.getPathError("SECURITY_ERROR", ex)});
        }
    }
}

