/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.filepath.nativeimpl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.filepath.Utils;

@BallerinaFunction(orgName="ballerina", packageName="filepath", functionName="resolve", isPublic=true)
public class Resolve
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
    }

    public static Object resolve(Strand strand, String inputPath) {
        try {
            Path realPath = Files.readSymbolicLink(Paths.get(inputPath, new String[0]).toAbsolutePath());
            return realPath.toString();
        }
        catch (NotLinkException ex) {
            return Utils.getPathError("NOT_LINK_ERROR", ex);
        }
        catch (IOException ex) {
            return Utils.getPathError("IO_ERROR", ex);
        }
        catch (SecurityException ex) {
            return Utils.getPathError("SECURITY_ERROR", ex);
        }
    }
}

