/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.filepath.nativeimpl;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.regex.PatternSyntaxException;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.stdlib.filepath.Utils;

public class FilePathUtils {
    private static final String GLOB_SYNTAX_FLAVOR = "glob:";

    public static Object absolute(BString inputPath) {
        try {
            return StringUtils.fromString((String)FileSystems.getDefault().getPath(inputPath.getValue(), new String[0]).toAbsolutePath().toString());
        }
        catch (InvalidPathException ex) {
            return Utils.getPathError("InvalidPathError", "Invalid path " + inputPath);
        }
    }

    public static Object matches(BString inputPath, BString pattern) {
        PathMatcher matcher;
        FileSystem fs = FileSystems.getDefault();
        try {
            matcher = !pattern.getValue().startsWith(GLOB_SYNTAX_FLAVOR) ? fs.getPathMatcher(GLOB_SYNTAX_FLAVOR + pattern) : fs.getPathMatcher(pattern.getValue());
        }
        catch (PatternSyntaxException ex) {
            return Utils.getPathError("InvalidPatternError", "Invalid pattern " + pattern);
        }
        if (inputPath == null) {
            return false;
        }
        return matcher.matches(Paths.get(inputPath.getValue(), new String[0]));
    }

    public static Object resolve(BString inputPath) {
        try {
            Path realPath = Files.readSymbolicLink(Paths.get(inputPath.getValue(), new String[0]).toAbsolutePath());
            return StringUtils.fromString((String)realPath.toString());
        }
        catch (NotLinkException ex) {
            return Utils.getPathError("NotLinkError", "Path is not a symbolic link " + inputPath);
        }
        catch (NoSuchFileException ex) {
            return Utils.getPathError("FileNotFoundError", "File does not exist at " + inputPath);
        }
        catch (IOException ex) {
            return Utils.getPathError("IOError", "IO error for " + inputPath);
        }
        catch (SecurityException ex) {
            return Utils.getPathError("SecurityError", "Security error for " + inputPath);
        }
    }
}

