/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.stdlib.io.channels.FileIOChannel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;

public class TempFileIOChannel
extends FileIOChannel {
    private String tempFilePath;

    public TempFileIOChannel(FileChannel channel, String tempFilePath) throws BallerinaIOException {
        super(channel);
        this.tempFilePath = tempFilePath;
    }

    @Override
    public void close() throws IOException {
        File tempFile;
        boolean isFileDeleted;
        super.close();
        if (this.tempFilePath != null && !this.tempFilePath.isEmpty() && !(isFileDeleted = (tempFile = new File(this.tempFilePath)).delete())) {
            throw new BallerinaException("Temporary file deletion failure occurred while closing TempFileIOChannel! ");
        }
    }
}

