/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels.base;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.ballerinalang.stdlib.io.channels.base.Buffer;
import org.ballerinalang.stdlib.io.channels.base.IOChannel;
import org.ballerinalang.stdlib.io.channels.base.readers.Reader;
import org.ballerinalang.stdlib.io.channels.base.writers.Writer;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Channel
implements IOChannel {
    private ByteChannel channel;
    private Reader reader;
    private Writer writer;
    private boolean hasReachedToEnd = false;
    private Buffer contentBuffer;
    private boolean readable;
    private static final Logger log = LoggerFactory.getLogger(Channel.class);

    public Channel(ByteChannel channel, Reader reader, Writer writer) throws BallerinaIOException {
        if (null != channel) {
            this.channel = channel;
            this.reader = reader;
            this.writer = writer;
            if (log.isDebugEnabled()) {
                log.debug("Initializing ByteChannel with ref id " + channel.hashCode());
            }
        } else {
            String message = "Provided channel cannot be initialized";
            throw new BallerinaIOException(message);
        }
    }

    @Deprecated
    public Channel(ByteChannel channel, Reader reader, Writer writer, int size) throws BallerinaIOException {
        if (null != channel) {
            this.channel = channel;
            this.reader = reader;
            this.writer = writer;
            this.contentBuffer = new Buffer(size);
            if (log.isDebugEnabled()) {
                log.debug("Initializing ByteChannel with ref id " + channel.hashCode());
            }
        } else {
            String message = "Provided channel cannot be initialized";
            throw new BallerinaIOException(message);
        }
    }

    public abstract void transfer(int var1, int var2, WritableByteChannel var3) throws IOException;

    @Override
    public abstract boolean isSelectable();

    @Override
    public int id() {
        return this.channel.hashCode();
    }

    @Override
    public boolean hasReachedEnd() {
        return this.hasReachedToEnd;
    }

    public ByteChannel getByteChannel() {
        return this.channel;
    }

    public int read(ByteBuffer buffer) throws IOException {
        int readBytes = this.reader.read(buffer, this.channel);
        if (readBytes < 0) {
            readBytes = 0;
            this.hasReachedToEnd = true;
        }
        return readBytes;
    }

    public int write(ByteBuffer content) throws IOException {
        return this.writer.write(content, this.channel);
    }

    public InputStream getInputStream() throws BallerinaIOException {
        if (!this.channel.isOpen()) {
            String message = "Channel is already closed.";
            throw new BallerinaIOException(message);
        }
        return Channels.newInputStream(this.channel);
    }

    public byte[] readFull(int numberOfBytes) throws IOException {
        ByteBuffer readBuffer = this.contentBuffer.get(numberOfBytes, this);
        byte[] content = readBuffer.array();
        int contentLength = readBuffer.capacity();
        if (content.length > numberOfBytes || contentLength < numberOfBytes) {
            content = Arrays.copyOfRange(content, 0, contentLength);
        }
        return content;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public void close() throws IOException {
        try {
            if (null != this.channel) {
                this.channel.close();
            } else {
                log.error("The channel has already being closed");
            }
        }
        catch (IOException e) {
            String message = "Error occurred while closing the connection";
            log.error(message, (Throwable)e);
            throw new IOException(message, e);
        }
    }
}

