/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.channels.base.IOChannel;
import org.ballerinalang.stdlib.io.csv.Format;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedRecordChannel
implements IOChannel {
    private String recordSeparator;
    private String fieldSeparator;
    private StringBuilder persistentCharSequence;
    private int recordCharacterCount = 100;
    private CharacterChannel channel;
    private boolean remaining = true;
    private int numberOfRecordsReadThroughChannel = 0;
    private int numberOfRecordsWrittenToChannel = 0;
    private Format format;
    private static final Logger log = LoggerFactory.getLogger(DelimitedRecordChannel.class);

    public DelimitedRecordChannel(CharacterChannel channel, Format format) {
        this.channel = channel;
        this.format = format;
        this.persistentCharSequence = new StringBuilder();
    }

    public DelimitedRecordChannel(CharacterChannel channel, String recordSeparator, String fieldSeparator) {
        this.recordSeparator = recordSeparator;
        this.fieldSeparator = fieldSeparator;
        this.channel = channel;
        this.persistentCharSequence = new StringBuilder();
    }

    @Override
    public boolean hasReachedEnd() {
        return !this.remaining && this.channel.hasReachedEnd();
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    private String getRecordSeparatorForReading() {
        if (null == this.format) {
            return this.recordSeparator;
        }
        return this.format.getReadRecSeparator();
    }

    private String getFieldSeparatorForReading() {
        if (null == this.format) {
            return this.fieldSeparator;
        }
        return this.format.getReadFieldSeparator();
    }

    private String getRecordSeparatorForWriting() {
        if (null == this.format) {
            return this.recordSeparator;
        }
        return this.format.getWriteRecSeparator();
    }

    private String getFieldSeparatorForWriting() {
        if (null == this.format) {
            return this.fieldSeparator;
        }
        return this.format.getWriteFieldSeparator();
    }

    private String readRecord() throws BallerinaIOException, IOException {
        String record = null;
        boolean minimumRecordCount = true;
        int numberOfSplits = 2;
        do {
            String[] delimitedRecord;
            if (log.isTraceEnabled()) {
                log.trace("char[] remaining in memory " + this.persistentCharSequence);
            }
            if ((delimitedRecord = this.persistentCharSequence.toString().split(this.getRecordSeparatorForReading(), 2)).length > 1) {
                record = this.processIdentifiedRecord(delimitedRecord);
                int recordCharacterLength = record.length();
                if (recordCharacterLength <= this.recordCharacterCount) continue;
                this.recordCharacterCount = record.length();
                continue;
            }
            this.readRecordFromChannel();
        } while (record == null && !this.channel.hasReachedEnd());
        if (null == record) {
            record = this.readFinalRecord();
        }
        return record;
    }

    private String readFinalRecord() {
        boolean minimumRemainingLength = false;
        String record = "";
        if (log.isDebugEnabled()) {
            log.debug("The content returned from the channel " + this.channel.hashCode() + " is <void>");
        }
        this.remaining = false;
        if (this.persistentCharSequence.length() > 0) {
            record = this.persistentCharSequence.toString();
            this.persistentCharSequence.setLength(0);
            if (log.isTraceEnabled()) {
                log.trace("char [] remaining in memory, will be marked as the last record " + record);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Final record is get from channel " + this.channel.hashCode() + " number of records get from channel " + (this.numberOfRecordsReadThroughChannel + 1));
        }
        return record;
    }

    private String readRecordFromChannel() throws IOException {
        String readCharacters = this.channel.read(this.recordCharacterCount);
        if (log.isTraceEnabled()) {
            log.trace("char [] get from channel," + this.channel.hashCode() + "=" + readCharacters);
        }
        this.persistentCharSequence.append(readCharacters);
        if (log.isTraceEnabled()) {
            log.trace("char [] appended to the memory " + this.persistentCharSequence);
        }
        return readCharacters;
    }

    private String processIdentifiedRecord(String[] delimitedRecords) {
        boolean minimumRemainingLength = false;
        boolean delimitedRecordIndex = false;
        boolean delimitedRemainingIndex = true;
        String recordContent = delimitedRecords[1];
        String record = delimitedRecords[0];
        this.persistentCharSequence.setLength(0);
        this.persistentCharSequence.append(recordContent);
        if (log.isTraceEnabled()) {
            log.trace("Record identified from remaining char[] in memory " + record);
            log.trace("The char[] left after split " + this.persistentCharSequence);
        }
        return record;
    }

    private String[] recursiveSplit(String record, String regex) {
        String[] splitRecords;
        int recursiveIndex = 2;
        String empty = "";
        ArrayList<String> records = new ArrayList<String>();
        do {
            splitRecords = record.split(regex, 2);
            int numberOfFields = splitRecords.length;
            String field = splitRecords[0];
            String string = record = numberOfFields == 2 ? splitRecords[1] : "";
            if (field.trim().isEmpty()) {
                field = null;
            }
            records.add(field);
        } while (splitRecords.length == 2);
        return records.toArray(new String[0]);
    }

    private String[] getFields(String record) {
        String fieldSeparatorForReading = this.getFieldSeparatorForReading();
        if (null != this.format && this.format.shouldIgnoreBlanks()) {
            return this.recursiveSplit(record, fieldSeparatorForReading);
        }
        return record.split(fieldSeparatorForReading);
    }

    public String[] read() throws IOException {
        boolean emptyArrayIndex = false;
        Object[] fields = new String[]{};
        if (this.remaining) {
            String record;
            if (log.isDebugEnabled()) {
                log.debug("Reading record " + this.numberOfRecordsReadThroughChannel + " from " + this.channel.hashCode());
            }
            if (!(record = this.readRecord()).isEmpty() || this.remaining) {
                fields = this.getFields(record);
                ++this.numberOfRecordsReadThroughChannel;
                if (log.isDebugEnabled()) {
                    log.debug("Record " + this.numberOfRecordsReadThroughChannel + " returned " + fields.length + " from channel " + this.channel.hashCode());
                }
                if (log.isTraceEnabled()) {
                    log.trace("The list of fields identified in record " + this.numberOfRecordsReadThroughChannel + "from channel " + this.channel.hashCode() + "," + Arrays.toString(fields));
                }
            }
        } else if (null != this.channel) {
            log.warn("The final record has already being processed through the channel " + this.channel.hashCode());
        } else {
            log.warn("The requested channel has already being closed");
        }
        return fields;
    }

    private String encloseField(String field) {
        return "\"" + field + "\"";
    }

    private String composeRecord(BValueArray fields) {
        StringBuilder recordConsolidator = new StringBuilder();
        long numberOfFields = fields.size();
        boolean fieldStartIndex = false;
        long secondLastFieldIndex = numberOfFields - 1L;
        if (log.isDebugEnabled()) {
            log.debug("Number of fields to be composed " + numberOfFields);
        }
        int fieldCount = 0;
        while ((long)fieldCount < numberOfFields) {
            String currentFieldString = fields.getString((long)fieldCount);
            if (currentFieldString.contains(this.getFieldSeparatorForWriting())) {
                currentFieldString = this.encloseField(currentFieldString);
            }
            recordConsolidator.append(currentFieldString);
            if ((long)fieldCount < secondLastFieldIndex) {
                recordConsolidator.append(this.getFieldSeparatorForWriting());
            }
            ++fieldCount;
        }
        String finalizedRecord = recordConsolidator.toString();
        return finalizedRecord;
    }

    private String composeRecord(ArrayValue fields) {
        StringBuilder recordConsolidator = new StringBuilder();
        long numberOfFields = fields.size();
        boolean fieldStartIndex = false;
        long secondLastFieldIndex = numberOfFields - 1L;
        if (log.isDebugEnabled()) {
            log.debug("Number of fields to be composed " + numberOfFields);
        }
        int fieldCount = 0;
        while ((long)fieldCount < numberOfFields) {
            String currentFieldString = fields.getString((long)fieldCount);
            if (currentFieldString.contains(this.getFieldSeparatorForWriting())) {
                currentFieldString = this.encloseField(currentFieldString);
            }
            recordConsolidator.append(currentFieldString);
            if ((long)fieldCount < secondLastFieldIndex) {
                recordConsolidator.append(this.getFieldSeparatorForWriting());
            }
            ++fieldCount;
        }
        String finalizedRecord = recordConsolidator.toString();
        return finalizedRecord;
    }

    public void write(BValueArray fields) throws IOException {
        boolean writeOffset = false;
        String record = this.composeRecord(fields);
        record = record + this.getRecordSeparatorForWriting();
        if (log.isTraceEnabled()) {
            log.trace("The record " + this.numberOfRecordsWrittenToChannel + " composed for writing, " + record);
        }
        this.channel.write(record, 0);
        if (log.isDebugEnabled()) {
            log.debug("Record " + this.numberOfRecordsReadThroughChannel + " written to the channel " + this.channel.hashCode());
        }
        ++this.numberOfRecordsWrittenToChannel;
    }

    public void write(ArrayValue fields) throws IOException {
        boolean writeOffset = false;
        String record = this.composeRecord(fields);
        record = record + this.getRecordSeparatorForWriting();
        if (log.isTraceEnabled()) {
            log.trace("The record " + this.numberOfRecordsWrittenToChannel + " composed for writing, " + record);
        }
        this.channel.write(record, 0);
        if (log.isDebugEnabled()) {
            log.debug("Record " + this.numberOfRecordsReadThroughChannel + " written to the channel " + this.channel.hashCode());
        }
        ++this.numberOfRecordsWrittenToChannel;
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public int id() {
        return this.channel.id();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean remaining() {
        return this.persistentCharSequence.length() > 0;
    }

    public boolean hasNext() throws IOException {
        String readChars;
        if (this.remaining && this.persistentCharSequence.length() == 0 && (readChars = this.readRecordFromChannel()).isEmpty()) {
            this.remaining = false;
        }
        return this.remaining;
    }
}

