/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.bytes;

import java.io.IOException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.BooleanResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseByteChannelEvent
implements Event {
    private Channel channel;
    private EventContext context;
    private static final Logger log = LoggerFactory.getLogger(CloseByteChannelEvent.class);

    public CloseByteChannelEvent(Channel channel, EventContext context) {
        this.channel = channel;
        this.context = context;
    }

    @Override
    public EventResult get() {
        BooleanResult result;
        try {
            this.channel.close();
            result = new BooleanResult(true, this.context);
        }
        catch (IOException e) {
            log.error("Error occurred while closing byte channel", (Throwable)e);
            this.context.setError(e);
            result = new BooleanResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while closing byte channel", e);
            this.context.setError(e);
            result = new BooleanResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.CLOSE;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

