/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.bytes;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.NumericResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadBytesEvent
implements Event {
    public static final String CONTENT_PROPERTY = "byte_content";
    private ByteBuffer content;
    private Channel channel;
    private EventContext context;
    private static final Logger log = LoggerFactory.getLogger(ReadBytesEvent.class);

    public ReadBytesEvent(Channel channel, byte[] content, EventContext context) {
        this.content = ByteBuffer.wrap(content);
        this.context = context;
        this.channel = channel;
    }

    private byte[] getContentData() {
        int bufferSize = this.content.limit();
        int readPosition = this.content.position();
        byte[] content = this.content.array();
        boolean startPosition = false;
        if (readPosition == bufferSize) {
            return content;
        }
        return Arrays.copyOfRange(content, 0, readPosition);
    }

    @Override
    public EventResult get() {
        NumericResult result;
        try {
            if (this.channel.hasReachedEnd()) {
                if (log.isDebugEnabled()) {
                    log.debug("Channel " + this.channel.hashCode() + " reached it's end");
                }
                this.context.setError(new Throwable("io.EOF"));
                result = new NumericResult(this.context);
            } else {
                int numberOfBytesRead = this.channel.read(this.content);
                byte[] content = this.getContentData();
                this.context.getProperties().put(CONTENT_PROPERTY, content);
                result = new NumericResult(numberOfBytesRead, this.context);
            }
        }
        catch (IOException e) {
            log.error("Error occurred while reading bytes", (Throwable)e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while reading bytes", e);
            this.context.setError(e);
            result = new NumericResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.READ;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

