/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.characters;

import java.io.IOException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.BooleanResult;
import org.ballerinalang.stdlib.io.nativeimpl.CloseReadableCharacterChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseCharacterChannelEvent
implements Event {
    private CharacterChannel channel;
    private EventContext context;
    private static final Logger log = LoggerFactory.getLogger(CloseReadableCharacterChannel.class);

    public CloseCharacterChannelEvent(CharacterChannel channel, EventContext context) {
        this.channel = channel;
        this.context = context;
    }

    @Override
    public EventResult get() {
        BooleanResult result;
        try {
            this.channel.close();
            result = new BooleanResult(true, this.context);
        }
        catch (IOException e) {
            log.error("Error occurred while closing character channel", (Throwable)e);
            this.context.setError(e);
            result = new BooleanResult(this.context);
        }
        catch (Throwable e) {
            log.error("Unidentified error occurred while closing character channel", e);
            this.context.setError(e);
            result = new BooleanResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.CLOSE;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

