/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.events.characters;

import java.io.IOException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.events.Event;
import org.ballerinalang.stdlib.io.events.EventContext;
import org.ballerinalang.stdlib.io.events.EventResult;
import org.ballerinalang.stdlib.io.events.EventType;
import org.ballerinalang.stdlib.io.events.result.AlphaResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCharactersEvent
implements Event {
    private CharacterChannel channel;
    private int numberOfCharacters;
    private EventContext context;
    private static final String EMPTY = "";
    private static final Logger log = LoggerFactory.getLogger(ReadCharactersEvent.class);

    public ReadCharactersEvent(CharacterChannel channel, int numberOfCharacters) {
        this.channel = channel;
        this.numberOfCharacters = numberOfCharacters;
    }

    public ReadCharactersEvent(CharacterChannel channel, int numberOfCharacters, EventContext context) {
        this.channel = channel;
        this.numberOfCharacters = numberOfCharacters;
        this.context = context;
    }

    @Override
    public EventResult get() {
        AlphaResult result;
        try {
            if (this.channel.hasReachedEnd()) {
                if (log.isDebugEnabled()) {
                    log.debug("Channel " + this.channel.hashCode() + " reached it's end");
                }
                this.context.setError(new Throwable("io.EOF"));
                result = new AlphaResult(EMPTY, this.context);
            } else {
                String content = this.channel.read(this.numberOfCharacters);
                result = new AlphaResult(content, this.context);
            }
        }
        catch (IOException e) {
            log.error("Error occurred while reading from character channel", (Throwable)e);
            this.context.setError(e);
            result = new AlphaResult(this.context);
        }
        catch (Throwable e) {
            log.error("IO error occurred while reading from character channel", e);
            this.context.setError(e);
            result = new AlphaResult(this.context);
        }
        return result;
    }

    @Override
    public int getChannelId() {
        return this.channel.id();
    }

    @Override
    public boolean isSelectable() {
        return this.channel.isSelectable();
    }

    @Override
    public EventType getType() {
        return EventType.READ;
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    @Override
    public boolean remaining() {
        return this.channel.remaining();
    }
}

